/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.eclipse.scada.da.data.AttributeWriteResultEntry;
import org.eclipse.scada.da.protocol.ngp.codec.Structures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteAttributesResult
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(WriteAttributesResult.class);
    public static final int MESSAGE_CODE = 4370;

    public int getMessageCode() {
        return 4370;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.da.data.message.WriteAttributesResult.class;
    }

    public org.eclipse.scada.da.data.message.WriteAttributesResult decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 4370) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 4370, messageCode));
        }
        int numberOfFields = _data.get();
        Response response = null;
        List<AttributeWriteResultEntry> attributeResults = null;
        ErrorInformation errorInformation = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    response = org.eclipse.scada.core.protocol.ngp.codec.Structures.decodeResponse((BinaryContext)_context, (IoBuffer)_data, (boolean)false);
                    break;
                }
                case 2: {
                    attributeResults = Structures.decodeListAttributeWriteResultEntry(_context, _data, true);
                    break;
                }
                case 3: {
                    errorInformation = org.eclipse.scada.core.protocol.ngp.codec.Structures.decodeErrorInformation((BinaryContext)_context, (IoBuffer)_data, (boolean)true);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.da.data.message.WriteAttributesResult(response, attributeResults, errorInformation);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.da.data.message.WriteAttributesResult value = (org.eclipse.scada.da.data.message.WriteAttributesResult)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(4370);
        data.put((byte)3);
        org.eclipse.scada.core.protocol.ngp.codec.Structures.encodeResponse((BinaryContext)context, (IoBuffer)data, (byte)1, (Response)value.getResponse());
        Structures.encodeCollectionAttributeWriteResultEntry(context, data, (byte)2, value.getAttributeResults());
        org.eclipse.scada.core.protocol.ngp.codec.Structures.encodeErrorInformation((BinaryContext)context, (IoBuffer)data, (byte)3, (ErrorInformation)value.getErrorInformation());
        data.flip();
        return data;
    }
}

