/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeManager;
import org.eclipse.scada.da.server.common.DataItemBase;
import org.eclipse.scada.da.server.common.WriteAttributesHelper;
import org.eclipse.scada.da.server.common.chain.ChainItem;
import org.eclipse.scada.da.server.common.chain.ChainProcessEntry;
import org.eclipse.scada.utils.concurrent.FutureTask;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public abstract class DataItemBaseChained
extends DataItemBase {
    protected Map<String, Variant> primaryAttributes = null;
    protected AttributeManager secondaryAttributes = null;
    protected volatile Set<ChainProcessEntry> chain = new CopyOnWriteArraySet<ChainProcessEntry>();
    protected final Executor executor;

    public DataItemBaseChained(DataItemInformation dataItemInformation, Executor executor) {
        super(dataItemInformation);
        this.executor = executor;
        this.primaryAttributes = new HashMap<String, Variant>();
        this.secondaryAttributes = new AttributeManager(this);
    }

    @Override
    public Map<String, Variant> getAttributes() {
        return this.secondaryAttributes.get();
    }

    @Override
    public NotifyFuture<WriteAttributeResults> startSetAttributes(final Map<String, Variant> attributes, final OperationParameters operationParameters) {
        FutureTask task = new FutureTask((Callable)new Callable<WriteAttributeResults>(){

            @Override
            public WriteAttributeResults call() throws Exception {
                return DataItemBaseChained.this.processSetAttributes(attributes, operationParameters);
            }
        });
        this.executor.execute((Runnable)task);
        return task;
    }

    protected WriteAttributeResults processSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        WriteAttributeResults writeAttributeResults = new WriteAttributeResults();
        for (ChainProcessEntry chainEntry : this.chain) {
            ChainItem chainItem = chainEntry.getWhat();
            WriteAttributeResults partialResult = chainItem.setAttributes(attributes);
            if (partialResult == null) continue;
            for (Map.Entry entry : partialResult.entrySet()) {
                if (((WriteAttributeResult)entry.getValue()).isError()) {
                    attributes.remove(entry.getKey());
                }
                writeAttributeResults.put((Object)((String)entry.getKey()), (Object)((WriteAttributeResult)entry.getValue()));
            }
        }
        this.process();
        return this.handleUnhandledAttributes(writeAttributeResults, attributes);
    }

    protected WriteAttributeResults handleUnhandledAttributes(WriteAttributeResults writeAttributeResults, Map<String, Variant> attributes) {
        return WriteAttributesHelper.errorUnhandled(writeAttributeResults, attributes);
    }

    protected abstract void process();

    public void setChain(Collection<ChainProcessEntry> chain) {
        if (chain == null) {
            this.chain = new CopyOnWriteArraySet<ChainProcessEntry>();
        } else {
            CopyOnWriteArraySet<ChainProcessEntry> newChain = new CopyOnWriteArraySet<ChainProcessEntry>(chain);
            this.chain = newChain;
        }
        this.process();
    }

    public void addChainElement(EnumSet<IODirection> when, ChainItem item) {
        if (this.chain.add(new ChainProcessEntry(when, item))) {
            this.process();
        }
    }

    public void addChainElement(IODirection when, ChainItem item) {
        if (this.chain.add(new ChainProcessEntry(EnumSet.of(when), item))) {
            this.process();
        }
    }

    public void removeChainElement(EnumSet<IODirection> when, ChainItem item) {
        int n = 0;
        Iterator<ChainProcessEntry> i = this.chain.iterator();
        while (i.hasNext()) {
            ChainProcessEntry entry = i.next();
            if (!entry.getWhen().equals(when) || entry.getWhat() != item) continue;
            i.remove();
            ++n;
        }
        if (n > 0) {
            this.process();
        }
    }

    protected Collection<ChainProcessEntry> getChainCopy() {
        return new ArrayList<ChainProcessEntry>(this.chain);
    }
}

