/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.chain;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.DataItemInformation;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemInformationBase;
import org.eclipse.scada.da.server.common.chain.ChainItem;
import org.eclipse.scada.da.server.common.chain.ChainProcessEntry;
import org.eclipse.scada.da.server.common.chain.DataItemBaseChained;
import org.eclipse.scada.da.server.common.chain.item.AutoTimestampChainItem;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class DataItemInputChained
extends DataItemBaseChained {
    protected Variant primaryValue = Variant.NULL;
    protected Variant secondaryValue = Variant.NULL;

    public DataItemInputChained(DataItemInformation dataItemInformation, Executor executor) {
        this(dataItemInformation, true, executor);
    }

    public DataItemInputChained(DataItemInformation dataItemInformation, boolean autoTimestamp, Executor executor) {
        super(dataItemInformation, executor);
        if (autoTimestamp) {
            this.addChainElement(IODirection.INPUT, (ChainItem)new AutoTimestampChainItem());
        }
    }

    public DataItemInputChained(String id, Executor executor) {
        this(new DataItemInformationBase(id, EnumSet.of(IODirection.INPUT)), true, executor);
    }

    public synchronized void updateData(Variant value, Map<String, Variant> attributes, AttributeMode mode) {
        boolean changed = false;
        if (value != null && !this.primaryValue.equals((Object)value)) {
            this.primaryValue = Variant.valueOf((Object)value);
            changed = true;
        }
        if (attributes != null) {
            if (mode == null) {
                mode = AttributeMode.UPDATE;
            }
            HashMap diff = new HashMap();
            if (mode == AttributeMode.SET) {
                AttributesHelper.set((Map)this.primaryAttributes, attributes, diff);
            } else {
                AttributesHelper.mergeAttributes((Map)this.primaryAttributes, attributes, diff);
            }
            boolean bl = changed = changed || !diff.isEmpty();
        }
        if (changed) {
            this.process();
        }
    }

    @Override
    protected void process() {
        Variant newSecondaryValue = Variant.valueOf((Object)this.primaryValue);
        HashMap<String, Variant> newAttributes = new HashMap<String, Variant>(this.primaryAttributes);
        for (ChainProcessEntry entry : this.getChainCopy()) {
            Variant newValue;
            if (!entry.getWhen().contains(IODirection.INPUT) || (newValue = entry.getWhat().process(newSecondaryValue, newAttributes)) == null) continue;
            newSecondaryValue = newValue;
        }
        Variant newValue = null;
        if (!this.secondaryValue.equals((Object)newSecondaryValue)) {
            newValue = this.secondaryValue = Variant.valueOf((Object)newSecondaryValue);
        }
        this.secondaryAttributes.set(newValue, newAttributes);
    }

    @Override
    public NotifyFuture<Variant> readValue() throws InvalidOperationException {
        return new InstantFuture((Object)this.secondaryValue);
    }

    @Override
    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        return new InstantErrorFuture((Throwable)new InvalidOperationException());
    }

    @Override
    protected Map<String, Variant> getCacheAttributes() {
        return this.secondaryAttributes.get();
    }

    @Override
    protected Variant getCacheValue() {
        return this.secondaryValue;
    }
}

