/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.ExecutionResult;
import org.eclipse.scada.da.server.exec.command.ProcessConfiguration;
import org.eclipse.scada.da.server.exec.command.ProcessListener;
import org.eclipse.scada.da.server.exec.extractor.Extractor;
import org.eclipse.scada.da.server.exec.util.CommandExecutor;

public class AbstractSingleCommand {
    protected final String id;
    private HiveCommon hive;
    protected final ProcessConfiguration processConfiguration;
    protected final Collection<Extractor> extractors;
    private FolderItemFactory itemFactory;
    private FolderCommon folderCommon;
    private DataItemInputChained runningItem;
    private DataItemInputChained exitCodeItem;
    private DataItemInputChained execItem;

    public AbstractSingleCommand(String id, ProcessConfiguration processConfiguration, Collection<Extractor> extractors) {
        this.id = id;
        this.processConfiguration = processConfiguration;
        this.extractors = extractors;
    }

    protected void execute(ProcessBuilder processBuilder, ProcessListener listener) {
        ExecutionResult result;
        this.runningItem.updateData(Variant.TRUE, null, null);
        try {
            result = CommandExecutor.executeCommand(processBuilder, listener);
        }
        finally {
            this.runningItem.updateData(Variant.FALSE, null, null);
            this.execItem.updateData(Variant.NULL, new HashMap(), AttributeMode.SET);
        }
        this.updateStatus(result);
        for (Extractor extractor : this.extractors) {
            extractor.process(result);
        }
    }

    private void updateStatus(ExecutionResult result) {
        this.exitCodeItem.updateData(Variant.valueOf((Object)result.getExitValue()), null, null);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("exec.runtime", Variant.valueOf((Object)result.getRuntime()));
        attributes.put("exec.exitCode", Variant.valueOf((Object)result.getExitValue()));
        attributes.put("exec.standardOutput", Variant.valueOf((Object)result.getOutput()));
        attributes.put("exec.errorOutput", Variant.valueOf((Object)result.getErrorOutput()));
        this.execItem.updateData(Variant.valueOf((Object)result.toString()), attributes, AttributeMode.SET);
    }

    public void register(Hive hive, FolderCommon parentFolder) {
        this.hive = hive;
        this.folderCommon = parentFolder;
        this.itemFactory = new DefaultChainItemFactory(this.hive, this.folderCommon, this.id, this.id);
        this.runningItem = this.itemFactory.createInput("running", null);
        this.exitCodeItem = this.itemFactory.createInput("exitCode", null);
        this.execItem = this.itemFactory.createInput("exec", null);
        for (Extractor ext : this.extractors) {
            ext.register(hive, this.itemFactory);
        }
    }

    public void unregister() {
        if (this.itemFactory != null) {
            this.itemFactory.dispose();
            this.itemFactory = null;
        }
        this.hive = null;
    }

    protected FolderItemFactory getItemFactory() {
        return this.itemFactory;
    }
}

