/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import java.util.Calendar;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSourceType
implements SourceType {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSourceType.class);
    protected static final int COMMON_HEADER = 10;
    private final int length;

    public AbstractSourceType(int dataLength) {
        this.length = 10 + dataLength;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public abstract void putValue(IoBuffer var1, Variant var2);

    @Override
    public void render(IoBuffer buffer, int offset, DataItemValue value) {
        IoBuffer slice = buffer.getSlice(offset, this.length);
        logger.trace("After Slice: {}", (Object)buffer);
        if (value != null) {
            slice.put(this.makeValidState(value));
            slice.put(this.makeState(value));
            slice.putLong(this.makeTimestamp(value.getTimestamp()));
            this.putValue(slice, value.getValue());
        } else {
            slice.put((byte)-1);
            slice.put(this.makeState(null));
            slice.putLong(this.makeTimestamp(null));
            this.putValue(slice, null);
        }
        logger.trace("Buffer: {}", (Object)buffer);
    }

    private byte makeValidState(DataItemValue value) {
        byte state = 0;
        if (!value.isConnected()) {
            state = (byte)(state | 1);
        }
        if (value.isError()) {
            state = (byte)(state | 2);
        }
        return state;
    }

    private byte makeState(DataItemValue value) {
        if (value == null) {
            return 0;
        }
        byte state = 0;
        if (value.isAlarm()) {
            state = (byte)(state | 1);
        }
        if (value.isWarning()) {
            state = (byte)(state | 2);
        }
        if (value.isManual()) {
            state = (byte)(state | 4);
        }
        if (value.isBlocked()) {
            state = (byte)(state | 8);
        }
        return state;
    }

    private long makeTimestamp(Calendar timestamp) {
        if (timestamp == null) {
            return System.currentTimeMillis();
        }
        return timestamp.getTimeInMillis();
    }
}

