/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.exporter.TabularExporter;
import org.eclipse.scada.da.server.common.item.factory.DefaultChainItemFactory;
import org.eclipse.scada.da.server.jdbc.AbstractQuery;
import org.eclipse.scada.da.server.jdbc.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularQuery
extends AbstractQuery {
    private static final Logger logger = LoggerFactory.getLogger(TabularQuery.class);
    private final int idColumn;
    private TabularExporter exporter;
    private final Map<String, String> updateMap;
    private TabularExporter.WriteHandlerFactory writeHandlerFactory;
    private Map<String, String> commands;

    public TabularQuery(String id, int idColumn, int period, String sql, Connection connection, Map<Integer, String> columnAliases, Map<String, String> updateMap, Map<String, String> commands) {
        super(id, period, sql, connection, columnAliases);
        this.idColumn = idColumn;
        this.updateMap = updateMap;
        this.commands = commands;
        this.writeHandlerFactory = new TabularExporter.WriteHandlerFactory(){

            public WriteHandler createColumnWriteHandler(String id, String columnName) {
                return TabularQuery.this.performColumnCreateWriteHandler(id, columnName);
            }

            public WriteHandler createCommandWriteHandler(String id, String command) {
                return TabularQuery.this.performCreateCommandWriteHandler(id, command);
            }
        };
    }

    protected WriteHandler performCreateCommandWriteHandler(String id, String command) {
        String commandSql = this.commands.get(command);
        if (commandSql == null || commandSql.isEmpty()) {
            return null;
        }
        final String sql = String.format(commandSql, id);
        return new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                TabularQuery.this.processUpdateSql(sql, value, operationParameters);
            }
        };
    }

    protected WriteHandler performColumnCreateWriteHandler(String id, String columnName) {
        String updateSql = this.updateMap.get(columnName);
        if (updateSql == null || updateSql.isEmpty()) {
            return null;
        }
        final String sql = String.format(updateSql, id);
        return new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                TabularQuery.this.processUpdateSql(sql, value, operationParameters);
            }
        };
    }

    protected void processUpdateSql(String updateSql, Variant value, OperationParameters operationParameters) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (java.sql.Connection c = this.connection.getConnection();){
            c.setAutoCommit(true);
            Throwable throwable2 = null;
            Object var8_11 = null;
            try (PreparedStatement stmt = c.prepareStatement(updateSql);){
                if (stmt.getParameterMetaData().getParameterCount() == 1 && !value.isNull()) {
                    stmt.setObject(1, value.getValue());
                }
                stmt.executeUpdate();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void register(ScheduledExecutorService timer, DefaultChainItemFactory parentItemFactory) {
        super.register(timer, parentItemFactory);
        this.exporter = new TabularExporter(this.itemFactory, this.writeHandlerFactory, this.commands.keySet());
    }

    @Override
    public void unregister() {
        if (this.exporter != null) {
            this.exporter.dispose();
            this.exporter = null;
        }
        super.unregister();
    }

    @Override
    protected void setGlobalError(Throwable e) {
        logger.error("Failed to query", e);
        this.exporter.setGlobalError(e);
    }

    @Override
    protected void doQuery() throws Exception {
        logger.debug("Perform query");
        Throwable throwable = null;
        Object var2_3 = null;
        try (java.sql.Connection connection = this.connection.getConnection();){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (PreparedStatement stmt = connection.prepareStatement(this.sql);){
                if (this.connection.getTimeout() != null) {
                    stmt.setQueryTimeout(this.connection.getTimeout() / 1000);
                }
                Throwable throwable3 = null;
                Object var8_13 = null;
                try (ResultSet result = stmt.executeQuery();){
                    this.processResult(result);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private void processResult(ResultSet result) throws SQLException {
        LinkedList<TabularExporter.Entry> entries = new LinkedList<TabularExporter.Entry>();
        logger.trace("Processing result");
        int count = result.getMetaData().getColumnCount();
        logger.trace("Column count: {}", (Object)count);
        while (result.next()) {
            logger.trace("Next row");
            String idValue = String.format("%s", result.getObject(this.idColumn));
            TabularExporter.Entry entry = new TabularExporter.Entry(idValue);
            entries.add(entry);
            int i = 1;
            while (i <= count) {
                String field = this.mapFieldName(i, result);
                entry.put(field, Variant.valueOf((Object)result.getObject(i)));
                ++i;
            }
        }
        this.exporter.update(entries);
    }
}

