/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.stock.items;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.da.server.stock.business.StockQuoteService;
import org.eclipse.scada.da.server.stock.domain.StockQuote;
import org.eclipse.scada.da.server.stock.items.StockQuoteListener;

public class UpdateManager {
    private final Map<String, StockQuoteListener> _registeredSymbols = new HashMap<String, StockQuoteListener>();
    private StockQuoteService _stockQuoteService = null;

    public synchronized void update() {
        if (!this._registeredSymbols.isEmpty()) {
            this.fireEvents(this._stockQuoteService.getStockQuotes(this._registeredSymbols.keySet()));
        }
    }

    public synchronized void add(String symbol, StockQuoteListener listener) {
        this._registeredSymbols.put(symbol, listener);
        this.updateNow(symbol);
    }

    protected void updateNow(String symbol) {
        this.fireEvents(this._stockQuoteService.getStockQuotes(Arrays.asList(symbol)));
    }

    protected void fireEvents(Collection<StockQuote> stockQuotes) {
        for (StockQuote stockQuote : stockQuotes) {
            StockQuoteListener listener = this._registeredSymbols.get(stockQuote.getSymbol());
            try {
                listener.update(stockQuote);
            }
            catch (Throwable throwable) {}
        }
    }

    public synchronized void remove(String symbol) {
        this._registeredSymbols.remove(symbol);
    }

    public void setStockQuoteService(StockQuoteService stockQuoteService) {
        this._stockQuoteService = stockQuoteService;
    }
}

