/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.exporter.http.server.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.exporter.http.DataPoint;
import org.eclipse.scada.hd.exporter.http.HttpExporter;
import org.eclipse.scada.hd.server.Service;
import org.eclipse.scada.hd.server.Session;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.PropertiesCredentialsCallback;
import org.eclipse.scada.utils.concurrent.AbstractFuture;

public class LocalHttpExporter
implements HttpExporter {
    private final Service hdService;
    private Session session = null;
    private final Lock lock;

    public LocalHttpExporter(Service hdService) throws Exception {
        this.hdService = hdService;
        this.lock = new ReentrantLock(true);
    }

    public List<DataPoint> getData(String item, String type, Date from, Date to, Integer number) {
        this.tryCreateSession();
        QueryParameters parameters = new QueryParameters(from.getTime(), to.getTime(), number.intValue());
        QueryFuture queryFuture = new QueryFuture(type);
        Query q = null;
        try {
            q = this.hdService.createQuery(this.session, item, parameters, (QueryListener)queryFuture, false);
            List list = (List)queryFuture.get(30L, TimeUnit.SECONDS);
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            queryFuture = null;
            if (q != null) {
                q.close();
                q = null;
            }
        }
    }

    private void tryCreateSession() {
        if (this.session != null) {
            return;
        }
        this.lock.lock();
        try {
            try {
                if (this.session == null) {
                    Properties props = this.makeProperties();
                    this.session = (Session)this.hdService.createSession(props, (CallbackHandler)new PropertiesCredentialsCallback(props)).get(30L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<String> getItems() {
        return new ArrayList<String>();
    }

    public List<String> getSeries(String itemId) {
        return new ArrayList<String>();
    }

    public void dispose() throws Exception {
        if (this.session != null && this.hdService != null) {
            this.hdService.closeSession((org.eclipse.scada.core.server.Session)this.session);
        }
    }

    private Properties makeProperties() {
        String user = System.getProperty("org.eclipse.scada.hd.exporter.http.server.user", "");
        String password = System.getProperty("org.eclipse.scada.hd.exporter.http.server.password", "");
        Properties props = new Properties();
        props.setProperty("user", user);
        props.setProperty("password", password);
        return props;
    }

    private class QueryFuture
    extends AbstractFuture<List<DataPoint>>
    implements QueryListener {
        final List<DataPoint> result = new ArrayList<DataPoint>();
        final String type;

        public QueryFuture(String type) {
            this.type = type;
        }

        public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
            int i = 0;
            for (ValueInformation vi : valueInformation) {
                DataPoint dp = new DataPoint();
                dp.setQuality(Double.valueOf(vi.getQuality()));
                dp.setManual(Double.valueOf(vi.getManualPercentage()));
                dp.setTimestamp(new Date(vi.getStartTimestamp()));
                dp.setValue(values.get(this.type).get(i));
                this.result.add(dp);
                ++i;
            }
        }

        public void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
        }

        public void updateState(QueryState state) {
            if (state == QueryState.COMPLETE || state == QueryState.DISCONNECTED) {
                this.setResult(this.result);
            }
        }
    }
}

