/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.views;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.ui.data.AbstractQueryBuffer;
import org.eclipse.scada.hd.ui.views.Messages;
import org.eclipse.scada.hd.ui.views.QueryViewPart;
import org.eclipse.scada.ui.utils.datetime.DateTimeDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryControlView
extends QueryViewPart
implements PropertyChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(QueryControlView.class);
    private Text startTimestampText;
    private Text endTimestampText;
    private Text entriesText;
    private Label stateText;
    private Text entriesRequestText;
    private Text endTimestampRequestText;
    private Text startTimestampRequestText;
    private QueryParameters requestParameters;
    private Button requestButton;
    private final Set<Control> controls = new HashSet<Control>();

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.createControls(parent);
        for (Control control : this.controls) {
            control.setEnabled(false);
        }
        this.addListener();
    }

    private void createControls(Composite part) {
        Composite parent = new Composite(part, 0);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.stateText = new Label(parent, 0);
        this.stateText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Group group = new Group(parent, 0);
        group.setText(Messages.QueryControlView_Group_Query_Text);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.QueryControlView_Label_From_Text);
        this.startTimestampText = new Text((Composite)group, 2056);
        this.startTimestampText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.QueryControlView_Label_To_Text);
        this.endTimestampText = new Text((Composite)group, 2056);
        this.endTimestampText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.QueryControlView_Label_Entries_Text);
        this.entriesText = new Text((Composite)group, 2056);
        this.entriesText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group = new Group(parent, 0);
        group.setText(Messages.QueryControlView_Group_Request_Text);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.QueryControlView_Label_From_Text);
        this.startTimestampRequestText = new Text((Composite)group, 2056);
        this.startTimestampRequestText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button button = new Button((Composite)group, 8);
        button.setLayoutData((Object)new GridData(1, 1, false, false));
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeDialog dlg = new DateTimeDialog(QueryControlView.this.getSite().getShell());
                if (QueryControlView.this.requestParameters != null) {
                    dlg.setTime(QueryControlView.this.requestParameters.getStartTimestamp());
                }
                dlg.open();
                Calendar c = dlg.getCalendar();
                if (c == null) {
                    return;
                }
                QueryControlView.this.requestParameters = new QueryParameters(c.getTimeInMillis(), QueryControlView.this.requestParameters.getEndTimestamp(), QueryControlView.this.requestParameters.getNumberOfEntries());
                QueryControlView.this.updateRequestParameters();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.QueryControlView_Label_To_Text);
        this.endTimestampRequestText = new Text((Composite)group, 2056);
        this.endTimestampRequestText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button = new Button((Composite)group, 8);
        button.setLayoutData((Object)new GridData(1, 1, false, false));
        button.setText("...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateTimeDialog dlg = new DateTimeDialog(QueryControlView.this.getSite().getShell());
                if (QueryControlView.this.requestParameters != null) {
                    dlg.setTime(QueryControlView.this.requestParameters.getEndTimestamp());
                }
                dlg.open();
                Calendar c = dlg.getCalendar();
                if (c == null) {
                    return;
                }
                QueryControlView.this.requestParameters = new QueryParameters(QueryControlView.this.requestParameters.getStartTimestamp(), c.getTimeInMillis(), QueryControlView.this.requestParameters.getNumberOfEntries());
                QueryControlView.this.updateRequestParameters();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.QueryControlView_Label_Entries_Text);
        this.entriesRequestText = new Text((Composite)group, 2048);
        this.entriesRequestText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.entriesRequestText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = false;
                StringBuilder text = new StringBuilder();
                String org = QueryControlView.this.entriesRequestText.getText();
                text.append(org);
                if (org.equals("") && e.text.equals("")) {
                    e.doit = true;
                    return;
                }
                text.replace(e.start, e.end, e.text);
                try {
                    String str = text.toString();
                    if (str.equals("")) {
                        e.doit = true;
                        return;
                    }
                    int i = Integer.parseInt(text.toString());
                    e.doit = i >= 0;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        this.entriesRequestText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueryControlView.this.updateEntries();
            }
        });
        this.controls.add((Control)this.entriesRequestText);
        Composite compControl1 = new Composite((Composite)group, 0);
        compControl1.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        compControl1.setLayout((Layout)new FillLayout(256));
        this.createControlButton(compControl1, Messages.QueryControlView_PaneLeft3_Button_Text, -3600, 0);
        this.createControlButton(compControl1, Messages.QueryControlView_PaneLeft2_Button_Text, -300, 0);
        this.createControlButton(compControl1, Messages.QueryControlView_PaneLeft1_Button_Text, -30, 0);
        this.createControlButton(compControl1, Messages.QueryControlView_PaneRight1_Button_Text, 30, 0);
        this.createControlButton(compControl1, Messages.QueryControlView_PaneRight2_Button_Text, 300, 0);
        this.createControlButton(compControl1, Messages.QueryControlView_PaneRight3_Button_Text, 3600, 0);
        Composite compControl2 = new Composite((Composite)group, 0);
        compControl2.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        compControl2.setLayout((Layout)new FillLayout(256));
        this.createControlButton(compControl2, Messages.QueryControlView_Add1_Button_Text, 0, 30);
        this.createControlButton(compControl2, Messages.QueryControlView_Add2_Button_Text, 0, 300);
        this.createControlButton(compControl2, Messages.QueryControlView_Add3_Button_Text, 0, 3600);
        this.createControlButton(compControl2, Messages.QueryControlView_Remove1_Button_Text, 0, -30);
        this.createControlButton(compControl2, Messages.QueryControlView_Remove2_Button_Text, 0, -300);
        this.createControlButton(compControl2, Messages.QueryControlView_Remove3_Button_Text, 0, -3600);
        this.requestButton = new Button((Composite)group, 8);
        this.requestButton.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.requestButton.setText(Messages.QueryControlView_Request_Button_Text);
        this.requestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryControlView.this.updateRequest();
            }
        });
        this.controls.add((Control)this.requestButton);
    }

    private void createControlButton(Composite compControl, String label, final int secondsOffset, final int secondsScale) {
        Button button = new Button(compControl, 8);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryControlView.this.changeRequest(secondsOffset, secondsScale);
            }
        });
        this.controls.add((Control)button);
    }

    protected void changeRequest(int secondsOffset, int secondsScale) {
        Calendar start = Calendar.getInstance();
        start.setTimeInMillis(this.requestParameters.getStartTimestamp());
        Calendar end = Calendar.getInstance();
        end.setTimeInMillis(this.requestParameters.getEndTimestamp());
        start.add(13, secondsOffset);
        end.add(13, secondsOffset);
        long diff = end.getTimeInMillis() - start.getTimeInMillis();
        diff /= 1000L;
        if ((diff += (long)secondsScale) < 0L) {
            diff = 0L;
        }
        end.setTimeInMillis(start.getTimeInMillis() + (diff *= 1000L));
        this.requestParameters = new QueryParameters(start.getTimeInMillis(), end.getTimeInMillis(), this.requestParameters.getNumberOfEntries());
        this.updateRequestParameters();
    }

    protected void updateRequest() {
        this.query.changeProperties(this.requestParameters);
    }

    private boolean updateEntries() {
        try {
            String text = this.entriesRequestText.getText();
            this.requestParameters = new QueryParameters(this.requestParameters.getStartTimestamp(), this.requestParameters.getEndTimestamp(), Integer.parseInt(text));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void updateRequestParameters() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryControlView.this.startTimestampRequestText.setText(String.format(Messages.QueryControlView_Format_Request_Date, QueryControlView.this.requestParameters.getStartTimestamp()));
                QueryControlView.this.endTimestampRequestText.setText(String.format(Messages.QueryControlView_Format_Request_Date, QueryControlView.this.requestParameters.getEndTimestamp()));
                QueryControlView.this.entriesRequestText.setText(String.format(Messages.QueryControlView_Format_Request_Entries, QueryControlView.this.requestParameters.getNumberOfEntries()));
            }
        });
    }

    @Override
    protected void setQuery(AbstractQueryBuffer query) {
        super.setQuery(query);
        this.query.addPropertyChangeListener(this);
        for (Control control : this.controls) {
            control.setEnabled(true);
        }
        this.requestParameters = query.getRequestParameters();
        this.updateRequestParameters();
    }

    @Override
    protected void clear() {
        if (this.query != null) {
            this.query.removePropertyChangeListener(this);
            this.stateText.setText("");
            this.startTimestampRequestText.setText("");
            this.endTimestampRequestText.setText("");
            this.entriesRequestText.setText("");
            this.startTimestampText.setText("");
            this.endTimestampText.setText("");
            this.entriesText.setText("");
            for (Control control : this.controls) {
                control.setEnabled(false);
            }
        }
        super.clear();
    }

    public void setFocus() {
        this.requestButton.setFocus();
    }

    public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
    }

    public void updateParameters(final QueryParameters parameters, Set<String> valueTypes) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryControlView.this.startTimestampText.setText(String.format(Messages.QueryControlView_Format_Query_Date, parameters.getStartTimestamp()));
                QueryControlView.this.endTimestampText.setText(String.format(Messages.QueryControlView_Format_Query_Date, parameters.getEndTimestamp()));
                QueryControlView.this.entriesText.setText(String.format(Messages.QueryControlView_Format_Query_Entries, parameters.getNumberOfEntries()));
            }
        });
    }

    private Display getDisplay() {
        return this.getSite().getShell().getDisplay();
    }

    public void updateState(QueryState state) {
        this.setState(this.query.getState(), this.query.getPercentFilled());
    }

    private void setState(final QueryState state, final double percentFilled) {
        logger.info("Update state: {} / {}", (Object)state, (Object)percentFilled);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryControlView.this.stateText.setText(String.format(Messages.QueryControlView_Format_StateString, state.toString(), 100.0 * percentFilled));
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("percentFilled".equals(evt.getPropertyName()) || "state".equals(evt.getPropertyName())) {
            this.setState(this.query.getState(), this.query.getPercentFilled());
        } else if ("requestParameters".equals(evt.getPropertyName())) {
            logger.info("Request set using property change: {}", (Object)this.query.getRequestParameters());
            this.requestParameters = this.query.getRequestParameters();
            this.updateRequestParameters();
        }
    }
}

