/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hds;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.scada.hds.DataStoreListener;
import org.eclipse.scada.hds.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractValueSource
implements ValueSource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractValueSource.class);
    private final Set<DataStoreListener> listeners = new CopyOnWriteArraySet<DataStoreListener>();

    @Override
    public void addListener(DataStoreListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(DataStoreListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyChange(Date start, Date end) {
        logger.debug("Notify change - start: {}, end: {}", (Object)start, (Object)end);
        for (DataStoreListener listener : this.listeners) {
            try {
                listener.storeChanged(start, end);
            }
            catch (Exception e) {
                logger.warn("Failed to handler listener", (Throwable)e);
            }
        }
    }
}

