/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.hd.hdsspy.editors;

import java.io.IOException;
import java.util.Date;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scada.hds.DataFileAccessorImpl;
import org.eclipse.scada.ide.hd.hdsspy.editors.ArchiveEntry;
import org.eclipse.scada.ide.hd.hdsspy.editors.ArchiveLoader;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.IFileEditorInput;

public class FileLoader
implements ArchiveLoader {
    private final IFileEditorInput input;

    public FileLoader(IFileEditorInput input) {
        this.input = input;
    }

    @Override
    public void performLoad(final WritableList list) throws CoreException {
        DataFileAccessorImpl accessor;
        IFile file = this.input.getFile();
        if (file == null) {
            return;
        }
        try {
            accessor = new DataFileAccessorImpl(file.getLocation().toFile());
        }
        catch (Exception e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.ide.hd.hdsspy", (Throwable)e));
        }
        try {
            try {
                accessor.forwardVisitAll(new DataFileAccessorImpl.EntryVisitor(){

                    public boolean visitEntry(long timestamp, double value, byte flags) {
                        list.add((Object)new ArchiveEntry(new Date(timestamp), value, (flags & 1) > 0, (flags & 2) > 0, (flags & 8) > 0, (flags & 4) > 0));
                        return true;
                    }
                });
            }
            catch (IOException e) {
                throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.ide.hd.hdsspy", (Throwable)e));
            }
        }
        finally {
            accessor.dispose();
        }
    }
}

