/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.codec;

import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.eclipse.scada.protocol.modbus.codec.ModbusProtocol;
import org.eclipse.scada.protocol.modbus.message.BaseMessage;
import org.eclipse.scada.protocol.modbus.message.Pdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusMasterProtocolFilter
extends IoFilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ModbusMasterProtocolFilter.class);

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof BaseMessage) {
            final Pdu pdu = ModbusProtocol.encodeAsMaster((BaseMessage)writeRequest.getMessage());
            nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapper(writeRequest){

                public Object getMessage() {
                    return pdu;
                }
            });
        } else {
            nextFilter.filterWrite(session, writeRequest);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        logger.trace("messageReceived - session: {}, message: {}", (Object)session, message);
        if (message instanceof Pdu) {
            nextFilter.messageReceived(session, ModbusProtocol.decodeAsMaster((Pdu)message));
        } else {
            nextFilter.messageReceived(session, message);
        }
    }
}

