/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.message;

import org.eclipse.scada.protocol.modbus.message.BaseMessage;

public class WriteMultiDataRequest
extends BaseMessage {
    private final int startAddress;
    private final byte[] data;

    public WriteMultiDataRequest(int transactionId, byte unitIdentifier, byte functionCode, int startAddress, byte[] data) {
        super(transactionId, unitIdentifier, functionCode);
        this.startAddress = startAddress;
        this.data = data;
        if (data.length % 2 == 1) {
            throw new IllegalArgumentException(String.format("Only an even number of bytes can be written. bytes = %s", data.length));
        }
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public byte[] getData() {
        return this.data;
    }
}

