/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common;

import java.io.File;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.mina.filter.ssl.KeyStoreFactory;
import org.apache.mina.filter.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslHelper {
    private static final Logger logger = LoggerFactory.getLogger(SslHelper.class);

    private SslHelper() {
    }

    protected static String get(Map<String, String> properties, String key, String defaultValue) {
        String value = properties.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static SslContextFactory createDefaultSslFactory(Map<String, String> properties, boolean clientMode) throws Exception {
        boolean requireSsl = properties.containsKey("requireSsl") && properties.get("requireSsl") != null && Boolean.parseBoolean(properties.get("requireSsl"));
        String defaultKeyStoreFile = String.valueOf(System.getProperty("user.home")) + "/.eclipseScada/keystore";
        String keyStoreFile = SslHelper.get(properties, "sslKeyStoreFile", null);
        if (keyStoreFile == null && !new File(defaultKeyStoreFile).canRead() && !requireSsl) {
            return null;
        }
        if (keyStoreFile == null) {
            logger.debug("Using default key store file: {}", (Object)defaultKeyStoreFile);
            keyStoreFile = defaultKeyStoreFile;
        }
        String trustStoreFile = SslHelper.get(properties, "sslTrustStoreFile", keyStoreFile);
        String password = SslHelper.get(properties, "sslPassword", null);
        String keyStorePassword = SslHelper.get(properties, "sslKeyStorePassword", password);
        String trustStorePassword = SslHelper.get(properties, "sslTrustStorePassword", keyStorePassword);
        String keyPassword = SslHelper.get(properties, "sslKeyPassword", keyStorePassword);
        if (!(keyStorePassword != null && trustStorePassword != null && keyPassword != null || requireSsl)) {
            return null;
        }
        SslContextFactory factory = new SslContextFactory();
        logger.debug("Default KeyStore: {}", (Object)KeyStore.getDefaultType());
        logger.debug("Default KeyManagerFactory: {}", (Object)KeyManagerFactory.getDefaultAlgorithm());
        logger.debug("Default TrustManagerFactory: {}", (Object)TrustManagerFactory.getDefaultAlgorithm());
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        keyStoreFactory.setDataFile(new File(keyStoreFile));
        keyStoreFactory.setPassword(keyStorePassword);
        KeyStoreFactory trustStoreFactory = new KeyStoreFactory();
        trustStoreFactory.setDataFile(new File(trustStoreFile));
        trustStoreFactory.setPassword(trustStorePassword);
        factory.setKeyManagerFactoryKeyStore(keyStoreFactory.newInstance());
        factory.setTrustManagerFactoryKeyStore(trustStoreFactory.newInstance());
        factory.setKeyManagerFactoryKeyStorePassword(keyPassword);
        return factory;
    }
}

