/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.audit.log.slf4j;

import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LogServiceImpl
implements AuditLogService {
    private static final Logger logger = LoggerFactory.getLogger(LogServiceImpl.class);

    public void info(String message, Object ... arguments) {
        logger.info(message, arguments);
    }

    public void debug(String message, Object ... arguments) {
        logger.debug(message, arguments);
    }

    public void info(String message, Throwable e, Object ... arguments) {
        logger.info(MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), e);
    }

    public void debug(String message, Throwable e, Object ... arguments) {
        logger.debug(MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), e);
    }

    public void authorizationRequested(AuthorizationRequest request) {
        logger.info("Authorization requested - {}", (Object)request);
    }

    public void authorizationFailed(AuthorizationContext context, AuthorizationRequest request, Throwable error) {
        logger.warn(String.format("Authorization failed - %s", request), error);
    }

    public void authorizationDone(AuthorizationContext context, AuthorizationRequest request, AuthorizationReply reply) {
        if (reply.isGranted()) {
            logger.info("Authorization granted - {} -> {}", (Object)request, (Object)reply);
        } else {
            logger.warn("Authorization rejected - {} -> {}", (Object)request, (Object)reply);
        }
    }
}

