/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.script;

import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationService;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.sec.provider.script.AuthorizationEntry;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.eclipse.scada.utils.script.Scripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAuthorizationProvider
implements AuthorizationService {
    private static final Logger logger = LoggerFactory.getLogger(ScriptAuthorizationProvider.class);
    private final ScriptEngineManager manager;
    private final ClassLoader classLoader = this.getClass().getClassLoader();
    private AuthenticationImplementation authenticationImplementation;

    public ScriptAuthorizationProvider() {
        this.manager = Scripts.createManager((ClassLoader)this.classLoader);
    }

    public void setAuthenticationImplementation(AuthenticationImplementation authenticationImplementation) {
        this.authenticationImplementation = authenticationImplementation;
    }

    public AuthorizationRule createRule(Map<String, String> properties) throws Exception {
        logger.debug("Creating rule - {}", properties);
        return this.createEntry(new ConfigurationDataHelper(properties));
    }

    private ScriptExecutor makeScript(ScriptEngine engine, String script) throws ScriptException {
        if (script == null || script.isEmpty()) {
            return null;
        }
        return new ScriptExecutor(engine, script, this.classLoader);
    }

    private AuthorizationEntry createEntry(ConfigurationDataHelper cfg) throws Exception {
        ScriptEngine scriptEngine = this.manager.getEngineByName(cfg.getString("script.engine", "JavaScript"));
        ScriptEngine callbackScriptEngine = this.manager.getEngineByName(cfg.getString("callbackScript.engine", "JavaScript"));
        ScriptExecutor script = this.makeScript(scriptEngine, cfg.getString("script"));
        ScriptExecutor callbackScript = this.makeScript(callbackScriptEngine, cfg.getString("callbackScript"));
        return new AuthorizationEntry(script, callbackScript, this.authenticationImplementation);
    }
}

