/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui;

import java.util.List;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.ConfirmationCallback;
import org.eclipse.scada.sec.ui.CallbackWidgetFactory;
import org.eclipse.scada.sec.ui.ConfirmationDialogFuture;
import org.eclipse.scada.sec.ui.DialogFuture;
import org.eclipse.scada.sec.ui.Helper;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DisplayCallbackHandler
implements CallbackHandler {
    private final Display display;
    private final String dialogTitle;
    private final String dialogMessage;
    private final Shell parentShell;

    public static DisplayCallbackHandler createDefault(Shell shell) {
        return new DisplayCallbackHandler(shell, "Logon to system", "Enter logon credentials");
    }

    public DisplayCallbackHandler(Display display, String dialogTitle, String dialogMessage) {
        this.parentShell = null;
        this.display = display;
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
    }

    public DisplayCallbackHandler(Shell parentShell, String dialogTitle, String dialogMessage) {
        this.parentShell = parentShell;
        this.display = parentShell.getDisplay();
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
    }

    public NotifyFuture<Callback[]> performCallback(Callback[] callbacks) {
        if (callbacks.length == 1 && callbacks[0] instanceof ConfirmationCallback) {
            return new ConfirmationDialogFuture(this.display, this.parentShell, callbacks, this.dialogTitle);
        }
        return this.performFullDialog(callbacks, Helper.makeFactories(callbacks));
    }

    private boolean tryInstant(List<CallbackWidgetFactory> factories) {
        if (factories.isEmpty()) {
            return true;
        }
        for (CallbackWidgetFactory cwf : factories) {
            if (cwf.tryInstantComplete()) continue;
            return false;
        }
        return true;
    }

    private NotifyFuture<Callback[]> performFullDialog(final Callback[] callbacks, final List<CallbackWidgetFactory> factories) {
        final DialogFuture future = this.parentShell != null ? new DialogFuture(this.parentShell, callbacks, factories) : new DialogFuture(this.display, callbacks, factories);
        future.setTitle(this.dialogTitle);
        future.setMessage(this.dialogMessage);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                DisplayCallbackHandler.this.processDialogFuture(callbacks, factories, future);
            }
        });
        return future;
    }

    private void processDialogFuture(Callback[] callbacks, List<CallbackWidgetFactory> factories, DialogFuture future) {
        if (this.tryInstant(factories)) {
            future.setEarlyResult(callbacks);
            return;
        }
        future.openDialog();
    }
}

