/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.io.IOException;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.sec.callback.PasswordCallback;
import org.eclipse.scada.sec.callback.UserNameCallback;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class CallbackHandlerTranslator
implements javax.security.auth.callback.CallbackHandler {
    private final CallbackHandler callbackHandler;

    public CallbackHandlerTranslator(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void handle(javax.security.auth.callback.Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] cbs = new Callback[callbacks.length];
        CallbackAdapter[] adapters = new CallbackAdapter[callbacks.length];
        int i = 0;
        while (i < callbacks.length) {
            javax.security.auth.callback.Callback c = callbacks[i];
            if (c instanceof NameCallback) {
                adapters[i] = new UserNameCallbackAdapter((NameCallback)c, i);
            } else if (c instanceof javax.security.auth.callback.PasswordCallback) {
                adapters[i] = new PasswordCallbackAdapter((javax.security.auth.callback.PasswordCallback)c, i);
            } else {
                throw new UnsupportedCallbackException(c);
            }
            cbs[i] = adapters[i].getAdapter();
            ++i;
        }
        NotifyFuture<Callback[]> future = Callbacks.callback(this.callbackHandler, cbs);
        try {
            future.get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        CallbackAdapter[] callbackAdapterArray = adapters;
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            CallbackAdapter adapter = callbackAdapterArray[n2];
            adapter.complete();
            ++n2;
        }
    }

    private static interface CallbackAdapter {
        public void complete();

        public Callback getAdapter();
    }

    private static class PasswordCallbackAdapter
    implements CallbackAdapter {
        private final javax.security.auth.callback.PasswordCallback callback;
        private final PasswordCallback adapter;

        public PasswordCallbackAdapter(javax.security.auth.callback.PasswordCallback callback, int order) {
            this.callback = callback;
            this.adapter = new PasswordCallback(callback.getPrompt(), order);
        }

        @Override
        public void complete() {
            this.callback.setPassword(this.adapter.getPlainPassword().toCharArray());
        }

        @Override
        public Callback getAdapter() {
            return this.adapter;
        }
    }

    private static class UserNameCallbackAdapter
    implements CallbackAdapter {
        private final NameCallback callback;
        private final UserNameCallback adapter;

        public UserNameCallbackAdapter(NameCallback callback, int order) {
            this.callback = callback;
            this.adapter = new UserNameCallback(callback.getPrompt(), order);
        }

        @Override
        public void complete() {
            this.callback.setName(this.adapter.getValue());
        }

        @Override
        public Callback getAdapter() {
            return this.adapter;
        }
    }
}

