/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.ui.data.ServiceQueryBuffer;
import org.eclipse.scada.ui.chart.viewer.input.LineInput;
import org.eclipse.scada.ui.chart.viewer.input.Messages;

public abstract class QueryInput
extends LineInput {
    private static final String PROP_STATE = "state";
    private ServiceQueryBuffer query;
    private PropertyChangeListener queryListener;
    private String state;
    private Date originalSelectedTimestamp;
    private String channelName;

    public QueryInput(ResourceManager resourceManager) {
        super(resourceManager);
    }

    @Override
    public void dispose() {
        if (this.query != null) {
            this.query.removePropertyChangeListener(this.queryListener);
        }
        super.dispose();
    }

    protected String getChannelName() {
        return this.channelName;
    }

    protected void setQuery(ServiceQueryBuffer query, String channelName) {
        this.query = query;
        this.channelName = channelName;
        this.queryListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                QueryInput.this.queryPropertyChange(evt);
            }
        };
        this.query.addPropertyChangeListener(this.queryListener);
        this.setState(this.makeState());
    }

    protected void queryPropertyChange(PropertyChangeEvent evt) {
        if (PROP_STATE.equals(evt.getPropertyName())) {
            this.setState(this.makeState());
        } else if ("percentFilled".equals(evt.getPropertyName())) {
            this.setState(this.makeState());
        }
        this.setSelection(this.originalSelectedTimestamp);
    }

    protected String makeState() {
        if (this.query == null) {
            return null;
        }
        QueryState state = this.query.getState();
        if (state == null) {
            return null;
        }
        switch (state) {
            case LOADING: {
                return String.format(Messages.QueryInput_Format_LoadingState, this.query.getState(), this.query.getPercentFilled() * 100.0);
            }
        }
        return this.query.getState().name();
    }

    protected void setState(String state) {
        this.state = state;
        this.firePropertyChange(PROP_STATE, this.state, this.state);
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    protected void setSelectedTimestamp(Date selectedTimestamp) {
        if (selectedTimestamp == null) {
            return;
        }
        this.originalSelectedTimestamp = selectedTimestamp;
        if (this.query == null) {
            return;
        }
        List infos = this.query.getValueInformation();
        if (infos == null) {
            return;
        }
        long c = selectedTimestamp.getTime();
        int i = 0;
        while (i < infos.size()) {
            ValueInformation vi = (ValueInformation)infos.get(i);
            if (vi != null && vi.getStartTimestamp() <= c && vi.getEndTimestamp() >= c) {
                super.setSelectedTimestamp(new Date(vi.getStartTimestamp()));
                this.setSelectedValue(QueryInput.valueToString(this.query, i, this.channelName));
                this.setSelectedQuality(QueryInput.qualityToString(vi));
                break;
            }
            ++i;
        }
    }

    private static String valueToString(ServiceQueryBuffer query, int index, String channelName) {
        List data = (List)query.getValues().get(channelName);
        if (data == null) {
            return null;
        }
        if (index >= data.size()) {
            return null;
        }
        Double value = (Double)data.get(index);
        if (value == null) {
            return null;
        }
        return String.format(Messages.QueryInput_Format_Value, value);
    }

    private static String qualityToString(ValueInformation valueInformation) {
        if (valueInformation == null) {
            return null;
        }
        return String.format(Messages.QueryInput_Format_Quality, valueInformation.getQuality() * 100.0);
    }
}

