/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.profile;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.scada.ui.chart.model.Profile;
import org.eclipse.scada.ui.chart.model.ProfileSwitcherType;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.chart.viewer.profile.ButtonProfileEntry;
import org.eclipse.scada.ui.chart.viewer.profile.CheckProfileEntry;
import org.eclipse.scada.ui.chart.viewer.profile.ProfileEntry;
import org.eclipse.scada.ui.chart.viewer.profile.RadioProfileEntry;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileManager {
    private static final Logger logger = LoggerFactory.getLogger(ProfileManager.class);
    private static final Comparator<? super Profile> COMPARATOR = new Comparator<Profile>(){

        @Override
        public int compare(Profile o1, Profile o2) {
            if (o1.getId() == null && o2.getId() == null) {
                return 0;
            }
            if (o1.getId() == null) {
                return -1;
            }
            return o1.getId().compareTo(o2.getId());
        }
    };
    private final WritableList list;
    private ProfileSwitcherType type = ProfileSwitcherType.BUTTON;
    private final Map<String, ProfileEntry> profileEntries = new HashMap<String, ProfileEntry>();
    private final List<Profile> profiles = new LinkedList<Profile>();
    private Profile activeProfile;
    private final ExtensionSpaceProvider extensionSpaceProvider;
    private Composite wrapper;
    private final DataBindingContext ctx;
    private final ChartContext chartContext;

    public ProfileManager(DataBindingContext ctx, Realm realm, ExtensionSpaceProvider extensionSpaceProvider, ChartContext chartContext) {
        this.ctx = ctx;
        this.extensionSpaceProvider = extensionSpaceProvider;
        this.chartContext = chartContext;
        this.list = new WritableList(realm);
        this.list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                ProfileManager.this.handleChange(event.diff);
            }
        });
    }

    public void setActiveProfile(Profile activeProfile) {
        logger.debug("Setting active profile: {}", (Object)activeProfile);
        if (this.activeProfile == activeProfile) {
            return;
        }
        this.activeProfile = activeProfile;
        ProfileEntry selectedEntry = null;
        if (activeProfile != null) {
            selectedEntry = this.profileEntries.get(activeProfile.getId());
        } else if (this.type == ProfileSwitcherType.CHECK) {
            try {
                selectedEntry = this.profileEntries.get(this.profiles.get(1).getId());
            }
            catch (Exception exception) {}
        }
        this.activateEntry(selectedEntry);
    }

    private void activateEntry(ProfileEntry selectedEntry) {
        for (ProfileEntry entry : this.profileEntries.values()) {
            entry.deactivate();
        }
        for (ProfileEntry entry : this.profileEntries.values()) {
            if (entry != selectedEntry) continue;
            entry.activate();
        }
    }

    public Profile getActiveProfile() {
        return this.activeProfile;
    }

    public void setType(ProfileSwitcherType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.refresh();
    }

    public ProfileSwitcherType getType() {
        return this.type;
    }

    protected void handleChange(ListDiff diff) {
        diff.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                ProfileManager.this.handleRemove((Profile)element);
            }

            public void handleAdd(int index, Object element) {
                ProfileManager.this.handleAdd((Profile)element);
            }
        });
    }

    protected void handleAdd(Profile profile) {
        this.profiles.add(profile);
        Collections.sort(this.profiles, COMPARATOR);
        this.refresh();
    }

    private void refresh() {
        this.disposeAllEntries();
        this.createAllEntries();
    }

    private void createAllEntries() {
        Composite extensionSpace = this.extensionSpaceProvider.getExtensionSpace();
        if (extensionSpace == null) {
            return;
        }
        this.wrapper = new Composite(extensionSpace, 0);
        this.wrapper.setLayout((Layout)new RowLayout(256));
        int i = 0;
        for (Profile profile : this.profiles) {
            ProfileEntry entry = this.createProfileEntry(profile, i);
            if (entry != null) {
                this.profileEntries.put(profile.getId(), entry);
            }
            ++i;
        }
        Label sep = new Label(this.wrapper, 514);
        sep.setLayoutData((Object)new RowData(-1, 20));
        extensionSpace.layout();
    }

    private ProfileEntry createProfileEntry(Profile profile, int i) {
        switch (this.type) {
            case BUTTON: {
                return new ButtonProfileEntry(this.ctx, this.wrapper, this, profile, this.chartContext);
            }
            case RADIO: {
                return new RadioProfileEntry(this.ctx, this.wrapper, this, profile, this.chartContext);
            }
            case CHECK: {
                if (i == 0) {
                    return new CheckProfileEntry(this.ctx, this.wrapper, this, profile, this.chartContext);
                }
                return new ProfileEntry(this.ctx, this, profile, this.chartContext);
            }
        }
        return null;
    }

    private void disposeAllEntries() {
        for (ProfileEntry entry : this.profileEntries.values()) {
            entry.dispose();
        }
        this.profileEntries.clear();
        if (this.wrapper != null) {
            this.wrapper.dispose();
            this.wrapper = null;
        }
    }

    protected void handleRemove(Profile profile) {
        this.profiles.remove(profile);
        ProfileEntry entry = this.profileEntries.remove(profile.getId());
        if (entry != null) {
            entry.dispose();
        }
    }

    public void dispose() {
        this.disposeAllEntries();
        this.list.dispose();
    }

    public WritableList getList() {
        return this.list;
    }
}

