/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.exporter;

import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter
implements ServiceListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractExporter.class);
    private final BundleContext context;

    public AbstractExporter(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws InvalidSyntaxException {
        String filter = String.format("(%s=%s)", "org.eclipse.scada.utils.osgi.jaxws.exportEnabled", true);
        AbstractExporter abstractExporter = this;
        synchronized (abstractExporter) {
            this.context.addServiceListener((ServiceListener)this, filter);
            ServiceReference[] refs = this.context.getServiceReferences(null, filter);
            if (refs != null) {
                ServiceReference[] serviceReferenceArray = refs;
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference ref = serviceReferenceArray[n2];
                    this.addService(ref);
                    ++n2;
                }
            }
        }
    }

    public void dispose() {
        this.context.removeServiceListener((ServiceListener)this);
    }

    protected abstract void exportService(ServiceReference<?> var1, Object var2);

    public synchronized void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.addService(event.getServiceReference());
                break;
            }
            case 4: {
                this.removeService(event.getServiceReference());
            }
        }
    }

    private void removeService(ServiceReference<?> serviceReference) {
        this.context.ungetService(serviceReference);
        this.unexportService(serviceReference);
    }

    protected abstract void unexportService(ServiceReference<?> var1);

    private void addService(ServiceReference<?> reference) {
        logger.debug("Found new service: {}", reference);
        Object service = this.context.getService(reference);
        try {
            this.exportService(reference, service);
            service = null;
        }
        finally {
            if (service != null) {
                this.context.ungetService(reference);
            }
        }
    }
}

