/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.eclipse.scada.utils.osgi.jdbc.CommonConnectionAccessor;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolConnectionAccessor
extends CommonConnectionAccessor {
    private static final String PREFIX = "org.eclipse.scada.utils.osgi.jdbc.pool.";
    private static final Logger logger = LoggerFactory.getLogger(PoolConnectionAccessor.class);
    private final PoolingDataSource dataSource;
    private final DataSource driverDataSource;
    private final GenericObjectPool<Object> connectionPool;
    private final PoolableConnectionFactory poolableConnectionFactory;

    public PoolConnectionAccessor(DataSourceFactory dataSourceFactory, Properties paramProperties) throws SQLException {
        logger.debug("Creating pool connection accessor : {}", (Object)paramProperties);
        this.connectionPool = new GenericObjectPool(null);
        this.connectionPool.setMaxActive(PoolConnectionAccessor.getInteger(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.maxActive", 8).intValue());
        this.connectionPool.setMaxIdle(PoolConnectionAccessor.getInteger(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.maxIdle", 8).intValue());
        this.connectionPool.setMinIdle(PoolConnectionAccessor.getInteger(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.minIdle", 1).intValue());
        this.connectionPool.setTestOnBorrow(PoolConnectionAccessor.getBoolean(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.testOnBorrow", true));
        this.connectionPool.setTestOnReturn(PoolConnectionAccessor.getBoolean(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.testOnReturn", true));
        this.connectionPool.setTimeBetweenEvictionRunsMillis(PoolConnectionAccessor.getLong(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.timeBetweenEvictionRunsMillis", -1L));
        this.connectionPool.setMinEvictableIdleTimeMillis(PoolConnectionAccessor.getLong(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.minEvictableIdleTimeMillis", 1800000L));
        this.connectionPool.setTestWhileIdle(PoolConnectionAccessor.getBoolean(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.testWhileIdle", false));
        this.connectionPool.setSoftMinEvictableIdleTimeMillis(PoolConnectionAccessor.getLong(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.softMinEvictableIdleTimeMillis", -1L));
        this.connectionPool.setNumTestsPerEvictionRun(PoolConnectionAccessor.getInteger(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.numTestsPerEvictionRun", 3).intValue());
        String connectionInitSql = PoolConnectionAccessor.getString(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.connectionInitSql", null);
        String validationQuery = PoolConnectionAccessor.getString(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.validationQuery", null);
        Integer validationQueryTimeout = PoolConnectionAccessor.getInteger(paramProperties, "org.eclipse.scada.utils.osgi.jdbc.pool.validationQueryTimeout", -1);
        this.driverDataSource = dataSourceFactory.createDataSource(paramProperties);
        DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(this.driverDataSource);
        this.poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, this.connectionPool, null, null, false, true);
        if (connectionInitSql != null) {
            this.poolableConnectionFactory.setConnectionInitSql(Arrays.asList(connectionInitSql));
        }
        if (validationQuery != null) {
            this.poolableConnectionFactory.setValidationQuery(validationQuery);
        }
        if (validationQueryTimeout != null) {
            this.poolableConnectionFactory.setValidationQueryTimeout(validationQueryTimeout.intValue());
        }
        this.dataSource = new PoolingDataSource(this.connectionPool);
    }

    private static long getLong(Properties paramProperties, String name, long defaultValue) {
        Object value = paramProperties.remove(name);
        if (value instanceof Number) {
            logger.debug("Parameter value is numeric - {} -> {}", (Object)name, value);
            return ((Number)value).longValue();
        }
        try {
            if (value != null) {
                logger.debug("Parameter value is string - {} -> {}", (Object)name, value);
                return Long.parseLong(value.toString());
            }
        }
        catch (Exception exception) {}
        Long result = Long.getLong(name, defaultValue);
        logger.debug("Parameter value via system property - {} -> {}", (Object)name, (Object)result);
        return result;
    }

    private static Integer getInteger(Properties paramProperties, String name, Integer defaultValue) {
        Object value = paramProperties.remove(name);
        if (value instanceof Number) {
            logger.debug("Parameter value is numeric - {} -> {}", (Object)name, value);
            return ((Number)value).intValue();
        }
        try {
            if (value != null) {
                logger.debug("Parameter value is string - {} -> {}", (Object)name, value);
                return Integer.parseInt(value.toString());
            }
        }
        catch (Exception exception) {}
        Integer result = Integer.getInteger(name, defaultValue);
        logger.debug("Parameter value via system property - {} -> {}", (Object)name, (Object)result);
        return result;
    }

    private static boolean getBoolean(Properties paramProperties, String name, boolean defaultValue) {
        Object value = paramProperties.remove(name);
        if (value instanceof Boolean) {
            logger.debug("Parameter value is boolean - {} -> {}", (Object)name, value);
            return (Boolean)value;
        }
        if (value instanceof Number) {
            logger.debug("Parameter value is numeric - {} -> {}", (Object)name, value);
            return ((Number)value).intValue() != 0;
        }
        try {
            if (value != null) {
                logger.debug("Parameter value is string - %s -> %s", (Object)name, value);
                return Boolean.parseBoolean(value.toString());
            }
        }
        catch (Exception exception) {}
        boolean result = Boolean.parseBoolean(System.getProperty(name, "" + defaultValue));
        logger.debug("Parameter value via system property - {} -> {}", (Object)name, (Object)result);
        return result;
    }

    private static String getString(Properties paramProperties, String name, String defaultValue) {
        Object value = paramProperties.remove(name);
        if (value instanceof String) {
            logger.debug("Parameter value is string - {} -> {}", (Object)name, value);
            return (String)value;
        }
        String result = System.getProperty(name, defaultValue);
        logger.debug("Parameter value via system property - {} -> {}", (Object)name, (Object)result);
        return result;
    }

    public void dispose() {
        logger.debug("Dispose");
        super.dispose();
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close connectionPool", (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

