/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.jdbc;

import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceHelper {
    public static final String DEFAULT_PREFIX = "org.eclipse.scada.jdbc";
    private static final Logger logger = LoggerFactory.getLogger(DataSourceHelper.class);

    private DataSourceHelper() {
    }

    public static boolean isConnectionPool(String specificPrefix, String defaultPrefix, boolean defaultValue) {
        String value = System.getProperty(String.valueOf(specificPrefix) + ".usePool", System.getProperty(String.valueOf(defaultPrefix) + ".usePool", "" + defaultValue));
        return Boolean.parseBoolean(value);
    }

    public static String getDriver(String specificPrefix, String defaultPrefix) {
        return DataSourceHelper.getDriver(System.getProperties(), specificPrefix, defaultPrefix);
    }

    public static String getDriver(Properties properties, String specificPrefix, String defaultPrefix) {
        return properties.getProperty(String.valueOf(specificPrefix) + ".driver", properties.getProperty(String.valueOf(defaultPrefix) + ".driver", null));
    }

    public static Properties getDataSourceProperties(String specificPrefix, String defaultPrefix) {
        return DataSourceHelper.getDataSourceProperties(System.getProperties(), specificPrefix, defaultPrefix);
    }

    public static Properties getDataSourceProperties(Properties properties, String specificPrefix, String defaultPrefix) {
        logger.debug("Getting datasource properties - specific: {} / default: {}", (Object)specificPrefix, (Object)defaultPrefix);
        Properties p = new Properties();
        String prefix = properties.containsKey(String.valueOf(specificPrefix) + ".driver") ? String.valueOf(specificPrefix) + ".properties." : String.valueOf(defaultPrefix) + ".properties.";
        logger.debug("Prefix is: {}", (Object)prefix);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key;
            logger.trace("Checking entry - key: {}, value: {}", entry.getKey(), entry.getValue());
            if (entry.getKey() == null || !(key = entry.getKey().toString()).startsWith(prefix)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding entry - key: {}, value: {}", (Object)key.substring(prefix.length()), entry.getValue());
            }
            p.put(key.substring(prefix.length()), entry.getValue());
        }
        return p;
    }
}

