/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent.task;

import java.util.concurrent.Future;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.task.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFutureHandler<T>
implements FutureListener<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResultFutureHandler.class);
    private final ResultHandler<T> resultHandler;

    public ResultFutureHandler(ResultHandler<T> resultHandler) {
        this.resultHandler = resultHandler;
    }

    @Override
    public void complete(Future<T> future) {
        try {
            this.resultHandler.completed(future.get());
        }
        catch (Throwable e) {
            logger.debug("Failed to complete", e);
            this.resultHandler.failed(e);
        }
    }
}

