/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.visibility;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibleComponent;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackingVisibleComponent
implements VisibleComponent {
    private static final Logger logger = LoggerFactory.getLogger(TrackingVisibleComponent.class);
    private final List<Control> controls = new LinkedList<Control>();
    private final WritableSet items = new WritableSet();
    protected SummaryProvider summaryProvider;

    protected void trackControl(Control control) {
        this.controls.add(control);
    }

    protected void untrackControl(Control control) {
        this.controls.remove(control);
    }

    protected void setSummaryProvider(SummaryProvider summaryProvider) {
        this.summaryProvider = summaryProvider;
    }

    @Override
    public SummaryProvider getSummaryProvider() {
        return this.summaryProvider;
    }

    @Override
    public void start() {
        for (Control control : this.controls) {
            if (!(control instanceof GenericComposite)) continue;
            ((GenericComposite)control).start();
        }
    }

    @Override
    public void stop() {
        for (Control control : this.controls) {
            if (!(control instanceof GenericComposite)) continue;
            ((GenericComposite)control).stop();
        }
    }

    @Override
    public void show() {
        logger.debug("Showing component");
        for (Control control : this.controls) {
            control.setVisible(true);
        }
    }

    @Override
    public void hide() {
        for (Control control : this.controls) {
            control.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        for (Control control : this.controls) {
            control.dispose();
        }
    }

    protected void trackItem(DataItemDescriptor item) {
        if (item != null) {
            this.items.add((Object)item);
        }
    }

    protected void untrackItem(DataItemDescriptor item) {
        this.items.remove((Object)item);
    }

    @Override
    public IObservableSet getDescriptors() {
        return this.items;
    }
}

