/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import org.eclipse.scada.vi.model.Alignment;
import org.eclipse.swt.graphics.RGB;

public final class Helper {
    private Helper() {
    }

    public static RGB makeColor(String color) {
        if (color == null) {
            return null;
        }
        if (color.startsWith("#")) {
            if (color.length() == 4) {
                return Helper.makeRGB(String.valueOf(color.substring(1, 2)) + "0", String.valueOf(color.substring(2, 3)) + "0", String.valueOf(color.substring(3, 4)) + "0");
            }
            if (color.length() >= 7) {
                return Helper.makeRGB(color.substring(1, 3), color.substring(3, 5), color.substring(5, 7));
            }
        }
        return null;
    }

    protected static RGB makeRGB(String r, String g, String b) {
        return new RGB(Integer.parseInt(r, 16), Integer.parseInt(g, 16), Integer.parseInt(b, 16));
    }

    public static int convertAlignment(Alignment alignment, int defaultValue) {
        if (alignment == null) {
            return defaultValue;
        }
        return Helper.convertPosition(alignment.getName(), defaultValue);
    }

    public static int convertPosition(String position, int defaultValue) {
        if ("CENTER".equals(position)) {
            return 2;
        }
        if ("LEFT".equals(position)) {
            return 1;
        }
        if ("RIGHT".equals(position)) {
            return 4;
        }
        if ("TOP".equals(position)) {
            return 8;
        }
        if ("BOTTOM".equals(position)) {
            return 32;
        }
        if ("EAST".equals(position)) {
            return 16;
        }
        if ("WEST".equals(position)) {
            return 8;
        }
        if ("NORTH".equals(position)) {
            return 1;
        }
        if ("SOUTH".equals(position)) {
            return 4;
        }
        return defaultValue;
    }
}

