/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user.viewer.ext;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.scada.vi.ui.user.Activator;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ext.ViewerExtension;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.Bundle;

public class DebugActionExtension
implements ViewerExtension {
    public static boolean hasDebug() {
        return Boolean.getBoolean("vi.debug");
    }

    @Override
    public Control create(Composite parent, ViewManager viewManager, boolean horizontal) {
        if (!DebugActionExtension.hasDebug()) {
            return null;
        }
        return new DebugHandler(parent, viewManager).getControl();
    }

    public static class DebugHandler {
        private final Label label;
        private Action reloadAction;
        private final ViewManager viewManager;

        public DebugHandler(Composite parent, ViewManager viewManager) {
            this.viewManager = viewManager;
            this.label = new Label(parent, 0);
            LocalResourceManager manager = new LocalResourceManager(JFaceResources.getResources((Display)this.label.getDisplay()), (Control)this.label);
            this.label.setImage(manager.createImageWithDefault(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("/resources/debugIcon.png"), (Map)Collections.EMPTY_MAP))));
            MenuManager menuManager = new MenuManager("#PopupMenu", "org.eclipse.scada.vi.ui.user.debugMenu");
            menuManager.setRemoveAllWhenShown(true);
            this.label.setMenu(menuManager.createContextMenu((Control)this.label));
            this.createActions();
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuManager) {
                    DebugHandler.this.contextMenuAboutToShow(menuManager);
                }
            });
            viewManager.registerMenuManager(menuManager);
        }

        public Control getControl() {
            return this.label;
        }

        protected void contextMenuAboutToShow(IMenuManager menuManager) {
            menuManager.add((IAction)this.reloadAction);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new Separator("additions"));
        }

        private void createActions() {
            this.reloadAction = new Action("Reload"){

                public void run() {
                    DebugHandler.this.viewManager.reloadCurrentView();
                }
            };
        }
    }
}

