/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.data;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.vi.data.DataItemRegistration;
import org.eclipse.scada.vi.data.DataValue;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrationManager {
    private static final long SERVICE_TIMEOUT = Long.getLong("org.eclipse.scada.vi.data.serviceTimeout", 1000L);
    private static final Logger logger = LoggerFactory.getLogger(RegistrationManager.class);
    private final Set<Listener> listeners = new LinkedHashSet<Listener>();
    private final Map<String, DataItemRegistration> registrations = new LinkedHashMap<String, DataItemRegistration>();
    private final AtomicReference<Map<String, DataValue>> currentValues = new AtomicReference(Collections.emptyMap());
    private final BundleContext context;
    private boolean open;
    private final String name;

    public RegistrationManager(BundleContext context) {
        this(context, null);
    }

    public RegistrationManager(BundleContext context, String name) {
        this.context = context;
        this.name = name;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.close();
        this.registrations.clear();
    }

    public void unregisterItem(String name) {
        DataItemRegistration registration = this.registrations.remove(name);
        if (registration != null && this.open) {
            registration.close();
            this.notifyRemove(name);
        }
    }

    public void open() {
        if (this.open) {
            return;
        }
        this.open = true;
        for (DataItemRegistration registration : this.registrations.values()) {
            registration.open();
        }
    }

    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        for (DataItemRegistration registration : this.registrations.values()) {
            registration.close();
        }
    }

    public void registerItem(String name, String itemId, String connectionId, boolean ignoreSummary, boolean nullInvalid) {
        if (itemId == null) {
            throw new IllegalArgumentException(String.format("'itemId' must not be null", new Object[0]));
        }
        if (this.open) {
            this.notifyChange(name, new Item(connectionId, itemId, Item.Type.ID), DataItemValue.DISCONNECTED, ignoreSummary, nullInvalid);
        }
        DataItemRegistration newRegistration = new DataItemRegistration(this, this.context, name, itemId, connectionId, ignoreSummary, nullInvalid);
        DataItemRegistration oldRegistration = this.registrations.put(name, newRegistration);
        if (this.open) {
            if (oldRegistration != null) {
                oldRegistration.close();
            }
            newRegistration.open();
        }
    }

    protected void notifyRemove(String name) {
        this.notifyValue(name, null);
    }

    public void notifyChange(String name, Item item, DataItemValue value, boolean ignoreSummary, boolean nullInvalid) {
        this.notifyValue(name, new DataValue(value, item, ignoreSummary, nullInvalid));
    }

    protected void notifyValue(String name, DataValue dataValue) {
        LinkedHashMap<String, DataValue> newMap;
        Map<String, DataValue> currentMap;
        int t = 0;
        do {
            ++t;
            currentMap = this.currentValues.get();
            newMap = new LinkedHashMap<String, DataValue>(currentMap);
            if (dataValue == null) {
                newMap.remove(name);
                continue;
            }
            newMap.put(name, dataValue);
        } while (!this.currentValues.compareAndSet(currentMap, newMap));
        if (t > 1) {
            logger.debug("Took {} updates", (Object)t);
        }
        for (Listener listener : this.listeners) {
            try {
                listener.triggerDataUpdate();
            }
            catch (Exception e) {
                logger.warn("Failed to notify", (Throwable)e);
            }
        }
    }

    public Map<String, DataValue> getData() {
        logger.debug("{} - getData: {}", (Object)this.name, this.currentValues.get());
        return Collections.unmodifiableMap(this.currentValues.get());
    }

    public void startWrite(String connectionId, String itemId, Variant value, CallbackHandler callbackHandler) throws InterruptedException {
        ConnectionIdTracker connectionTracker = new ConnectionIdTracker(this.context, connectionId, null, ConnectionService.class);
        connectionTracker.open();
        try {
            ConnectionService service = (ConnectionService)connectionTracker.waitForService(SERVICE_TIMEOUT);
            service.getConnection().startWrite(itemId, value, null, callbackHandler);
        }
        finally {
            connectionTracker.close();
        }
    }

    public void startWriteAttributes(String connectionId, String itemId, Map<String, Variant> attributes, CallbackHandler callbackHandler) throws InterruptedException {
        ConnectionIdTracker connectionTracker = new ConnectionIdTracker(this.context, connectionId, null, ConnectionService.class);
        connectionTracker.open();
        try {
            ConnectionService service = (ConnectionService)connectionTracker.waitForService(SERVICE_TIMEOUT);
            service.getConnection().startWriteAttributes(itemId, attributes, null, callbackHandler);
        }
        finally {
            connectionTracker.close();
        }
    }

    public Collection<Item> getItems() {
        LinkedHashSet<Item> result = new LinkedHashSet<Item>(this.registrations.size());
        for (DataItemRegistration reg : this.registrations.values()) {
            result.add(reg.getItem());
        }
        return result;
    }

    public static interface Listener {
        public void triggerDataUpdate();
    }
}

