/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.design.service.DesignServices;
import org.eclipse.sirius.business.api.helper.SiriusUtil;
import org.eclipse.sirius.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.viewpoint.DDiagram;
import org.eclipse.sirius.viewpoint.DDiagramElement;
import org.eclipse.sirius.viewpoint.DNodeList;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DSemanticDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewServices
extends DesignServices {
    public Collection<EPackage> getPackageDependencies(EPackage source) {
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        for (EClass containedClassifiers : Iterables.filter((Iterable)source.getEClassifiers(), EClass.class)) {
            dependencies.addAll(this.externalDependencies(containedClassifiers));
        }
        dependencies.remove(source);
        return dependencies;
    }

    private Set<EPackage> externalDependencies(EClass containedClassifiers) {
        LinkedHashSet dependencies = Sets.newLinkedHashSet();
        for (EStructuralFeature eRef : containedClassifiers.getEAllStructuralFeatures()) {
            if (eRef.getEType() == null || eRef.getEType().getEPackage() == null) continue;
            dependencies.add(eRef.getEType().getEPackage());
        }
        for (EClass superClazz : containedClassifiers.getEAllSuperTypes()) {
            if (superClazz.getEPackage() == null) continue;
            dependencies.add(superClazz.getEPackage());
        }
        return dependencies;
    }

    public Integer getDependenciesAmount(EObject a) {
        return 2;
    }

    public String getDependenciesTooltip(EClass clazz, DSemanticDecorator view) {
        DDiagram diag = SiriusUtil.findDiagram((EObject)view);
        if (diag != null) {
            Set<EPackage> displayedPackages = this.getDisplayedEPackages(diag);
            displayedPackages.remove(clazz.getEPackage());
            LinkedHashSet explanations = Sets.newLinkedHashSet();
            if (diag != null) {
                for (EPackage dep : this.externalDependencies(clazz)) {
                    if (!displayedPackages.contains(dep)) continue;
                    explanations.add("Dependency to " + dep.getNsURI() + ": \n" + this.externalDependenciesExplanation(dep, clazz));
                }
            }
            return Joiner.on((char)'\n').join((Iterable)explanations);
        }
        return "";
    }

    public String getDependenciesLabel(EClass clazz) {
        return String.valueOf(clazz.getName()) + " (" + this.externalDependencies(clazz).size() + ")";
    }

    public Collection<EClassifier> getElementsIntroducingDependencies(EPackage source, DSemanticDiagram diagram) {
        LinkedHashSet classifiersIntroducingDependencies = Sets.newLinkedHashSet();
        Set<EPackage> otherPackages = this.getDisplayedEPackages((DDiagram)diagram);
        otherPackages.remove(source);
        for (EClass containedClassifiers : Iterables.filter((Iterable)source.getEClassifiers(), EClass.class)) {
            for (EStructuralFeature eRef : containedClassifiers.getEAllStructuralFeatures()) {
                if (eRef.getEType() == null || !otherPackages.contains(eRef.getEType().getEPackage())) continue;
                classifiersIntroducingDependencies.add(eRef.getEContainingClass());
            }
            for (EClass superClazz : containedClassifiers.getEAllSuperTypes()) {
                if (!otherPackages.contains(superClazz.getEPackage())) continue;
                classifiersIntroducingDependencies.add(containedClassifiers);
            }
        }
        return classifiersIntroducingDependencies;
    }

    private Set<EPackage> getDisplayedEPackages(DDiagram diagram) {
        LinkedHashSet otherPackages = Sets.newLinkedHashSet();
        for (DNodeList list : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), DNodeList.class)) {
            if (new DDiagramElementQuery((DDiagramElement)list).isHidden() || !(list.getTarget() instanceof EPackage)) continue;
            otherPackages.add((EPackage)list.getTarget());
        }
        return otherPackages;
    }

    private String externalDependenciesExplanation(EPackage dep, EClass clazz) {
        LinkedHashSet explanations = Sets.newLinkedHashSet();
        for (EStructuralFeature eRef : clazz.getEAllStructuralFeatures()) {
            if (eRef.getEType() == null || eRef.getEType().getEPackage() != dep) continue;
            explanations.add(" - " + eRef.eClass().getName() + " " + eRef.getName() + " refers to type " + eRef.getEType().getName() + " in package " + dep.getName());
        }
        for (EClass superClazz : clazz.getEAllSuperTypes()) {
            if (superClazz.getEPackage() != dep) continue;
            explanations.add(" - EClass" + clazz.getName() + " extends type " + superClazz.getName() + " in package " + dep.getName());
        }
        return Joiner.on((char)'\n').join((Iterable)explanations);
    }
}

