/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.design.service.DiagnosticAttachment;
import org.eclipse.emf.ecoretools.design.service.EAttributeServices;
import org.eclipse.emf.ecoretools.design.service.EOperationServices;
import org.eclipse.emf.ecoretools.design.service.EReferenceServices;
import org.eclipse.emf.ecoretools.design.service.RelatedElementsSwitch;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.AllContents;
import org.eclipse.sirius.viewpoint.DDiagram;
import org.eclipse.sirius.viewpoint.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.EdgeTarget;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignServices
extends EReferenceServices {
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";

    public Collection<EObject> allRoots(EObject any) {
        Resource res = any.eResource();
        if (res != null && res.getResourceSet() != null) {
            ArrayList<EObject> roots = new ArrayList<EObject>();
            for (Resource childRes : res.getResourceSet().getResources()) {
                roots.addAll((Collection<EObject>)childRes.getContents());
            }
            return roots;
        }
        return Collections.emptySet();
    }

    public Collection<EPackage> rootEPackages(EObject any) {
        return Sets.newLinkedHashSet((Iterable)Iterables.filter(this.allRoots(any), EPackage.class));
    }

    public Boolean isEPackage(EObject any) {
        return any instanceof EPackage;
    }

    public Boolean isEClass(EObject any) {
        return any instanceof EClass;
    }

    public Boolean isEEnum(EObject any) {
        return any instanceof EEnum;
    }

    public EObject eContainerEContainer(EObject any) {
        if (any.eContainer() != null) {
            return any.eContainer().eContainer();
        }
        return null;
    }

    public Collection<EStringToStringMapEntryImpl> getVisibleAnnotations(EObject self, DSemanticDiagram diag) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (EModelElement displayed : this.getDisplayedEModelElements(diag)) {
            EAnnotation eAnnot;
            if (displayed instanceof EAttribute || displayed instanceof EEnumLiteral || displayed instanceof EOperation || (eAnnot = displayed.getEAnnotation(GEN_MODEL_PACKAGE_NS_URI)) == null) continue;
            for (EStringToStringMapEntryImpl mapEntry : Iterables.filter((Iterable)eAnnot.getDetails(), EStringToStringMapEntryImpl.class)) {
                if (!"documentation".equals(mapEntry.getKey())) continue;
                result.add(mapEntry);
            }
        }
        return result;
    }

    public boolean hasNoClassifier(DSemanticDiagram diagram) {
        UnmodifiableIterator it = Iterators.filter((Iterator)diagram.getOwnedDiagramElements().iterator(), DSemanticDecorator.class);
        while (it.hasNext()) {
            DSemanticDecorator dec = (DSemanticDecorator)it.next();
            if (!(dec.getTarget() instanceof EClassifier)) continue;
            return true;
        }
        return false;
    }

    public Collection<EClass> getDisplayedEClasses(DSemanticDiagram diagram) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        UnmodifiableIterator it = Iterators.filter((Iterator)diagram.eAllContents(), DSemanticDecorator.class);
        while (it.hasNext()) {
            DSemanticDecorator dec = (DSemanticDecorator)it.next();
            if (!(dec.getTarget() instanceof EClass)) continue;
            result.add((EClass)dec.getTarget());
        }
        return result;
    }

    public Collection<EReference> getEReferencesToDisplay(EPackage root, DSemanticDiagram diagram) {
        Collection<EClass> eClasses = this.getDisplayedEClasses(diagram);
        LinkedHashSet eRefs = Sets.newLinkedHashSet();
        for (EClass clazz : eClasses) {
            eRefs.addAll(clazz.getEAllReferences());
        }
        return eRefs;
    }

    public Boolean targetIsInterface(EClass clazz, EObject view) {
        EdgeTarget target;
        if (view instanceof DEdge && (target = ((DEdge)view).getTargetNode()) instanceof DSemanticDecorator && ((DSemanticDecorator)target).getTarget() instanceof EClass) {
            return ((EClass)((DSemanticDecorator)target).getTarget()).isInterface();
        }
        return false;
    }

    public List<EReference> getEOppositeSemanticElements(EReference ref) {
        LinkedHashSet allRefs = Sets.newLinkedHashSet();
        allRefs.add(ref);
        if (ref.getEOpposite() != null) {
            allRefs.add(ref.getEOpposite());
        }
        return Ordering.natural().onResultOf((Function)new Function<EReference, String>(){

            public String apply(EReference input) {
                return input.getName();
            }
        }).sortedCopy((Iterable)allRefs);
    }

    public Collection<EModelElement> getDisplayedEModelElements(DSemanticDiagram diagram) {
        LinkedHashSet modelelements = Sets.newLinkedHashSet();
        UnmodifiableIterator it = Iterators.filter((Iterator)Iterators.concat((Iterator)Iterators.singletonIterator((Object)diagram), (Iterator)diagram.eAllContents()), DSemanticDecorator.class);
        while (it.hasNext()) {
            DSemanticDecorator dec = (DSemanticDecorator)it.next();
            if (!(dec.getTarget() instanceof EModelElement)) continue;
            modelelements.add((EModelElement)dec.getTarget());
        }
        return modelelements;
    }

    public List<EObject> getValidsForDiagram(EObject element, DSemanticDecorator containerView) {
        Predicate<EObject> validForClassDiagram = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input instanceof EPackage || input instanceof EClassifier;
            }
        };
        return this.allValidSessionElements(element, validForClassDiagram);
    }

    public Collection<EObject> getRelated(EObject firstView, List<EObject> allSelectedViews, DDiagram diag) {
        LinkedHashSet relateds = Sets.newLinkedHashSet();
        for (DSemanticDecorator decorator : Iterables.filter(allSelectedViews, DSemanticDecorator.class)) {
            relateds.addAll(new RelatedElementsSwitch().getRelatedElements(decorator.getTarget()));
        }
        return relateds;
    }

    private List<EObject> allValidSessionElements(EObject cur, Predicate<EObject> validForClassDiagram) {
        Session found = SessionManager.INSTANCE.getSession(cur);
        ArrayList result = Lists.newArrayList();
        if (found != null) {
            for (Resource res : found.getSemanticResources()) {
                if (!res.getURI().isPlatformResource() && !res.getURI().isPlatformPlugin()) continue;
                Iterators.addAll((Collection)result, (Iterator)Iterators.filter((Iterator)res.getAllContents(), validForClassDiagram));
            }
        }
        return result;
    }

    public String eResourceName(EObject current) {
        if (current != null && current.eResource() != null) {
            return current.eResource().getURI().lastSegment();
        }
        return null;
    }

    public String render(EAttribute attr) {
        return new EAttributeServices().render(attr);
    }

    public EAttribute performEdit(EAttribute attr, String editString) {
        return new EAttributeServices().performEdit(attr, editString);
    }

    public String render(EOperation op) {
        return new EOperationServices().render(op);
    }

    public String renderTooltip(EObject current) {
        String result = "";
        Optional<Diagnostic> diag = DiagnosticAttachment.get(current);
        if (diag.isPresent()) {
            result = String.valueOf(result) + this.prettyMessage((Diagnostic)diag.get());
        }
        return result;
    }

    private String prettyMessage(Diagnostic diag) {
        String result = "";
        for (Diagnostic child : diag.getChildren()) {
            result = String.valueOf(result) + "\n" + this.severityLabel(child.getSeverity()) + " : " + child.getMessage();
            result = String.valueOf(result) + this.prettyMessage(child);
        }
        return result;
    }

    private String severityLabel(int severity) {
        switch (severity) {
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 0: {
                return "OK";
            }
        }
        return "UNKNOWN";
    }

    public String renderEOperationTooltip(EOperation op) {
        return new EOperationServices().renderEOperationTooltip(op);
    }

    public EOperation performEdit(EOperation op, String editString) {
        return new EOperationServices().performEdit(op, editString);
    }

    public List<ENamedElement> getAllAssociatedElements(EOperation op) {
        return new EOperationServices().getAllAssociatedElements(op);
    }

    public String renderTooltip(EClass klass) {
        return String.valueOf(((EPackage)klass.eContainer()).getName()) + "." + klass.getName();
    }

    @Override
    public String render(EReference ref) {
        return new EReferenceServices().render(ref);
    }

    public String renderEOpposite(EReference ref) {
        if (ref.getEOpposite() != null) {
            return new EReferenceServices().render(ref.getEOpposite());
        }
        return "";
    }

    @Override
    public EReference performEdit(EReference ref, String editString) {
        return new EReferenceServices().performEdit(ref, editString);
    }

    public EClassifier findTypeByName(EObject obj, String name) {
        EClassifier result = this.findTypeByName(this.allRoots(obj), name);
        if (result == null) {
            result = this.findTypeByNameFrom((EObject)EcorePackage.eINSTANCE, name);
        }
        return result;
    }

    public EObject getRootContainer(EObject eObject) {
        return EcoreUtil.getRootContainer((EObject)eObject);
    }

    private EClassifier findTypeByName(Iterable<EObject> roots, String name) {
        for (EObject root : roots) {
            EClassifier result = this.findTypeByNameFrom(root, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private EClassifier findTypeByNameFrom(EObject root, String name) {
        if (root instanceof EClassifier && this.nameMatches((EClassifier)root, name)) {
            return (EClassifier)root;
        }
        for (EObject obj : AllContents.of((EObject)root)) {
            if (!(obj instanceof EClassifier) || !this.nameMatches((EClassifier)obj, name)) continue;
            return (EClassifier)obj;
        }
        return null;
    }

    private boolean nameMatches(EClassifier type, String name) {
        if (type != null && type.getName() != null && name != null) {
            return type.getName().trim().equalsIgnoreCase(name.trim());
        }
        return false;
    }

    public Boolean hasError(EObject eObj) {
        if (eObj instanceof EClass || eObj instanceof EStructuralFeature) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
            DiagnosticAttachment.getOrCreate(eObj, diagnostic);
            if (diagnostic.getSeverity() == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isEDataType(EObject eObj) {
        if (eObj.eClass() == EcorePackage.eINSTANCE.getEDataType()) {
            return true;
        }
        return false;
    }

    public Boolean isDDiagram(EObject any, EObject view) {
        return view instanceof DDiagram;
    }

    public List<EObject> eOperationSemanticElements(EOperation eOp) {
        ArrayList result = Lists.newArrayList((Iterable)Ordering.natural().onResultOf((Function)new Function<EParameter, String>(){

            public String apply(EParameter arg0) {
                return arg0.getName();
            }
        }).sortedCopy((Iterable)eOp.getEParameters()));
        result.add(0, eOp);
        return result;
    }

    public Boolean viewContainerNotSemanticContainer(EObject self, DSemanticDiagram diag) {
        if (diag.getTarget() != self.eContainer()) {
            return true;
        }
        return false;
    }

    public Boolean noEOpposite(EReference ref) {
        if (ref.getEOpposite() == null) {
            return true;
        }
        return false;
    }

    public boolean hasNoDocAnnotation(EObject eObj) {
        if (eObj instanceof EModelElement) {
            return EcoreUtil.getDocumentation((EModelElement)((EModelElement)eObj)) == null;
        }
        return true;
    }

    public void showPropertiesViewAction(EObject object) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet");
        }
        catch (PartInitException exception) {
            EcoreEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public EEnumLiteral arrowsFillDiamond(EObject any) {
        return ViewpointPackage.eINSTANCE.getEdgeArrows().getEEnumLiteral("FillDiamond");
    }

    public EEnumLiteral fontFormatBold(EObject any) {
        return ViewpointPackage.eINSTANCE.getFontFormat().getEEnumLiteral("bold");
    }

    public void openContextHelp(EObject any, final String contextID) throws IOException {
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() != null) {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), contextID);
                        PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
                    }
                }
            });
        }
    }
}

