/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.ICompareFilter;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.internal.expressions.util.LRUCache;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class DocLineComparator
implements ITokenComparator {
    private IDocument fDocument;
    private int fLineOffset;
    private int fLineCount;
    private int fLength;
    private boolean fIgnoreWhiteSpace;
    private ICompareFilter[] fCompareFilters;
    private char fContributor;
    private LRUCache fCompareFilterCache;

    public DocLineComparator(IDocument document, IRegion region, boolean ignoreWhiteSpace) {
        this(document, region, ignoreWhiteSpace, null, '?');
    }

    public DocLineComparator(IDocument document, IRegion region, boolean ignoreWhiteSpace, ICompareFilter[] compareFilters, char contributor) {
        this.fDocument = document;
        this.fIgnoreWhiteSpace = ignoreWhiteSpace;
        this.fCompareFilters = compareFilters;
        this.fContributor = contributor;
        boolean cacheFilteredLines = false;
        if (compareFilters != null && compareFilters.length > 0) {
            cacheFilteredLines = true;
            int i = 0;
            while (i < compareFilters.length) {
                if (!compareFilters[i].canCacheFilteredRegions()) {
                    cacheFilteredLines = false;
                    break;
                }
                ++i;
            }
        }
        this.fCompareFilterCache = cacheFilteredLines ? new LRUCache(1024) : null;
        this.fLineOffset = 0;
        if (region != null) {
            this.fLength = region.getLength();
            int start = region.getOffset();
            try {
                this.fLineOffset = this.fDocument.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
            if (this.fLength == 0) {
                this.fLineCount = 1;
            } else {
                int endLine = this.fDocument.getNumberOfLines();
                try {
                    endLine = this.fDocument.getLineOfOffset(start + this.fLength);
                }
                catch (BadLocationException badLocationException) {}
                this.fLineCount = endLine - this.fLineOffset + 1;
            }
        } else {
            this.fLength = document.getLength();
            this.fLineCount = this.fDocument.getNumberOfLines();
        }
    }

    public int getRangeCount() {
        return this.fLineCount;
    }

    public int getTokenStart(int line) {
        try {
            IRegion r = this.fDocument.getLineInformation(this.fLineOffset + line);
            return r.getOffset();
        }
        catch (BadLocationException badLocationException) {
            return this.fDocument.getLength();
        }
    }

    public int getTokenLength(int line) {
        return this.getTokenStart(line + 1) - this.getTokenStart(line);
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator otherComparator, int otherIndex) {
        if (otherComparator != null && otherComparator.getClass() == this.getClass()) {
            DocLineComparator other = (DocLineComparator)otherComparator;
            if (this.fIgnoreWhiteSpace) {
                String[] linesToCompare = this.extract(thisIndex, otherIndex, other, false);
                return this.compare(linesToCompare[0], linesToCompare[1]);
            }
            int tlen = this.getTokenLength(thisIndex);
            int olen = other.getTokenLength(otherIndex);
            if (this.fCompareFilters != null && this.fCompareFilters.length > 0) {
                String[] linesToCompare = this.extract(thisIndex, otherIndex, other, true);
                return linesToCompare[0].equals(linesToCompare[1]);
            }
            if (tlen == olen) {
                String[] linesToCompare = this.extract(thisIndex, otherIndex, other, false);
                return linesToCompare[0].equals(linesToCompare[1]);
            }
        }
        return false;
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private String[] extract(int thisIndex, int otherIndex, DocLineComparator other, boolean includeSeparator) {
        String[] extracts = new String[2];
        if (this.fCompareFilters != null && this.fCompareFilters.length > 0) {
            if (this.fCompareFilterCache != null && other.fCompareFilterCache != null) {
                extracts[0] = (String)this.fCompareFilterCache.get((Object)new Integer(thisIndex));
                if (extracts[0] == null) {
                    extracts[0] = Utilities.applyCompareFilters(this.extract(thisIndex, includeSeparator), this.fContributor, other.extract(otherIndex, includeSeparator), other.fContributor, this.fCompareFilters);
                    this.fCompareFilterCache.put((Object)new Integer(thisIndex), (Object)extracts[0]);
                }
                extracts[1] = (String)other.fCompareFilterCache.get((Object)new Integer(otherIndex));
                if (extracts[1] == null) {
                    extracts[1] = Utilities.applyCompareFilters(other.extract(otherIndex, includeSeparator), other.fContributor, this.extract(thisIndex, includeSeparator), this.fContributor, this.fCompareFilters);
                    other.fCompareFilterCache.put((Object)new Integer(otherIndex), (Object)extracts[1]);
                }
            } else {
                String thisLine = this.extract(thisIndex, includeSeparator);
                String otherLine = other.extract(otherIndex, includeSeparator);
                extracts = new String[]{Utilities.applyCompareFilters(thisLine, this.fContributor, otherLine, other.fContributor, this.fCompareFilters), Utilities.applyCompareFilters(otherLine, other.fContributor, thisLine, this.fContributor, this.fCompareFilters)};
            }
        } else {
            extracts = new String[]{this.extract(thisIndex, includeSeparator), other.extract(otherIndex, includeSeparator)};
        }
        return extracts;
    }

    private String extract(int line, boolean includeSeparator) {
        if (line < this.fLineCount) {
            try {
                if (includeSeparator) {
                    return this.fDocument.get(this.fDocument.getLineOffset(line), this.fDocument.getLineLength(line));
                }
                IRegion r = this.fDocument.getLineInformation(this.fLineOffset + line);
                return this.fDocument.get(r.getOffset(), r.getLength());
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private boolean compare(String s1, String s2) {
        int l1 = s1.length();
        int l2 = s2.length();
        int c1 = 0;
        int c2 = 0;
        int i1 = 0;
        int i2 = 0;
        while (c1 != -1) {
            char c;
            c1 = -1;
            while (i1 < l1) {
                if (Character.isWhitespace(c = s1.charAt(i1++))) continue;
                c1 = c;
                break;
            }
            c2 = -1;
            while (i2 < l2) {
                if (Character.isWhitespace(c = s2.charAt(i2++))) continue;
                c2 = c;
                break;
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }
}

