/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.utils.ColorRegistry;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTextPropertySection;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStringListPropertySection
extends AbstractTextPropertySection {
    public static final Pattern STRING_LIST_PATTERN = Pattern.compile("(\\w)*(,(\\w)+)*");

    @Override
    protected String getFeatureAsString() {
        StringBuffer result = new StringBuffer();
        List<String> values = this.getStringListValues(this.getEObject());
        Iterator<String> itValue = values.iterator();
        while (itValue.hasNext()) {
            String nextValue = itValue.next();
            result.append(nextValue);
            if (!itValue.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    @Override
    protected Object getNewFeatureValue(String newText) {
        return Arrays.asList(newText.split(","));
    }

    @Override
    protected void verifyField(Event e) {
        String value = this.getText().getText();
        if (value == null || value.equals("") || this.isTextValid()) {
            this.setErrorMessage(null);
            this.getText().setBackground(null);
            e.doit = true;
        } else {
            this.setErrorMessage(Messages.AbstractStringListPropertySection_InvalidSequence);
            this.getText().setBackground(ColorRegistry.COLOR_ERROR);
            e.doit = false;
        }
    }

    @Override
    protected boolean isTextValid() {
        return STRING_LIST_PATTERN.matcher(this.getText().getText()).matches();
    }

    @Override
    protected EStructuralFeature getFeature() {
        return null;
    }

    @Override
    protected Object getOldFeatureValue() {
        return this.getStringListValues(this.getEObject());
    }

    @Override
    protected void createCommand(Object oldValue, final Object newValue) {
        EditingDomain editingDomain = this.getEditingDomain();
        if (this.getEObjectList().size() == 1) {
            if (oldValue != newValue) {
                editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                    protected void doExecute() {
                        AbstractStringListPropertySection.this.setStringListValues(AbstractStringListPropertySection.this.getEObject(), (List)newValue);
                    }
                });
            }
        } else {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (final EObject nextObject : this.getEObjectList()) {
                List oldWildcards = ExtendedMetaData.INSTANCE.getWildcards((EStructuralFeature)nextObject);
                if (oldWildcards == newValue) continue;
                editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                    protected void doExecute() {
                        AbstractStringListPropertySection.this.setStringListValues(nextObject, (List)newValue);
                    }
                });
            }
            editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    protected abstract List<String> getStringListValues(EObject var1);

    protected abstract void setStringListValues(EObject var1, List<String> var2);
}

