/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class EditUIUtil {
    public static boolean openEditor(EObject eObject) throws PartInitException {
        URI uri;
        Resource resource;
        if (eObject != null && (resource = eObject.eResource()) != null && (uri = resource.getURI()) != null) {
            URIEditorInput editorInput = null;
            if (uri.isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (workspaceResource instanceof IFile) {
                    editorInput = EclipseUtil.createFileEditorInput((IFile)workspaceResource);
                }
            } else {
                editorInput = new URIEditorInput(uri);
            }
            if (editorInput != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.openEditor((IEditorInput)editorInput, workbench.getEditorRegistry().getDefaultEditor(uri.lastSegment()).getId());
                return editorPart != null;
            }
        }
        return false;
    }

    public static URI getURI(IEditorInput editorInput) {
        return EditUIUtil.getURI(editorInput, null);
    }

    public static URI getURI(IEditorInput editorInput, URIConverter uriConverter) {
        URI result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            result = EclipseUtil.getURI(editorInput, uriConverter);
        }
        if (result == null) {
            result = editorInput instanceof URIEditorInput ? ((URIEditorInput)editorInput).getURI().trimFragment() : URI.createURI((String)editorInput.getName());
        }
        return result;
    }

    public static IEditorDescriptor getDefaultEditor(String fileName) {
        return fileName != null && fileName.length() != 0 ? EditUIUtil.getDefaultEditor(fileName, Platform.getContentTypeManager().findContentTypesFor(fileName)) : null;
    }

    public static IEditorDescriptor getDefaultEditor(InputStream contents, String fileName) {
        if (contents != null) {
            try {
                return EditUIUtil.getDefaultEditor(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName));
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
        return EditUIUtil.getDefaultEditor(fileName);
    }

    private static IEditorDescriptor getDefaultEditor(String fileName, IContentType[] contentTypes) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes.length == 0) {
            return editorRegistry.getDefaultEditor(fileName, null);
        }
        IEditorDescriptor result = null;
        int i = 0;
        while (result == null && i < contentTypes.length) {
            result = editorRegistry.getDefaultEditor(fileName, contentTypes[i]);
            ++i;
        }
        return result;
    }

    public static IEditorDescriptor getDefaultEditor(URI uri, URIConverter uriConverter) {
        String fileName = URI.decode((String)uri.lastSegment());
        if (uriConverter == null) {
            uriConverter = URIConverter.INSTANCE;
        }
        InputStream stream = null;
        try {
            stream = uriConverter.createInputStream(uri);
            IEditorDescriptor iEditorDescriptor = EditUIUtil.getDefaultEditor(stream, fileName);
            return iEditorDescriptor;
        }
        catch (IOException e) {
            EMFEditUIPlugin.INSTANCE.log(e);
            IEditorDescriptor iEditorDescriptor = EditUIUtil.getDefaultEditor(fileName);
            return iEditorDescriptor;
        }
        finally {
            EditUIUtil.close(stream);
        }
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
    }

    public static IEditorDescriptor[] getEditors(String fileName, boolean defaultsOnly) {
        return fileName != null && fileName.length() != 0 ? EditUIUtil.getEditors(fileName, Platform.getContentTypeManager().findContentTypesFor(fileName), defaultsOnly) : new IEditorDescriptor[]{};
    }

    public static IEditorDescriptor[] getEditors(InputStream contents, String fileName, boolean defaultsOnly) {
        if (contents != null) {
            try {
                return EditUIUtil.getEditors(fileName, Platform.getContentTypeManager().findContentTypesFor(contents, fileName), defaultsOnly);
            }
            catch (IOException e) {
                EMFEditUIPlugin.INSTANCE.log(e);
            }
        }
        return EditUIUtil.getEditors(fileName, defaultsOnly);
    }

    private static IEditorDescriptor[] getEditors(String fileName, IContentType[] contentTypes, boolean defaultsOnly) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes.length == 0) {
            return editorRegistry.getEditors(fileName, null);
        }
        UniqueEList result = new UniqueEList();
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType contentType = iContentTypeArray[n2];
            if (defaultsOnly) {
                IEditorDescriptor editor = editorRegistry.getDefaultEditor(fileName, contentType);
                if (editor != null) {
                    result.add(editor);
                }
            } else {
                result.addAll(Arrays.asList(editorRegistry.getEditors(fileName, contentType)));
            }
            ++n2;
        }
        return result.toArray(new IEditorDescriptor[result.size()]);
    }

    public static IEditorDescriptor[] getEditors(URI uri, URIConverter uriConverter, boolean defaultsOnly) {
        String fileName = URI.decode((String)uri.lastSegment());
        if (uriConverter == null) {
            uriConverter = URIConverter.INSTANCE;
        }
        InputStream stream = null;
        try {
            stream = uriConverter.createInputStream(uri);
            IEditorDescriptor[] iEditorDescriptorArray = EditUIUtil.getEditors(stream, fileName, defaultsOnly);
            return iEditorDescriptorArray;
        }
        catch (IOException e) {
            EMFEditUIPlugin.INSTANCE.log(e);
            IEditorDescriptor[] iEditorDescriptorArray = EditUIUtil.getEditors(fileName, defaultsOnly);
            return iEditorDescriptorArray;
        }
        finally {
            EditUIUtil.close(stream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseUtil {
        static final Class<?> FILE_CLASS;
        static final Class<?> FILE_REVISION_CLASS;
        static final Method FILE_REVISION_GET_URI_METHOD;
        static final Method FILE_REVISION_GET_STORAGE;
        static final Class<?> URI_EDITOR_INPUT_CLASS;
        static final Class<?> STORAGE_CLASS;
        static final Class<?> STORAGE_EDITOR_INPUT_CLASS;
        static final Class<?> JAR_ENTRY_RESOURCE_CLASS;
        static final Method JAR_ENTRY_RESOURCE_GET_PACKAGE_FRAGMENT_ROOT;
        static final Class<?> NON_JAVA_RESOURCE_CLASS;
        static final Field NON_JAVA_RESOURCE_FIELD;

        static {
            Class<IFile> fileClass = null;
            try {
                fileClass = IFile.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FILE_CLASS = fileClass;
            FILE_REVISION_CLASS = EclipseUtil.loadClass("org.eclipse.team.core", "org.eclipse.team.core.history.IFileRevision");
            FILE_REVISION_GET_URI_METHOD = EclipseUtil.getMethod(FILE_REVISION_CLASS, "getURI", new Class[0]);
            FILE_REVISION_GET_STORAGE = EclipseUtil.getMethod(FILE_REVISION_CLASS, "getStorage", IProgressMonitor.class);
            Class<IURIEditorInput> uriEditorInputClass = null;
            try {
                uriEditorInputClass = IURIEditorInput.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            URI_EDITOR_INPUT_CLASS = uriEditorInputClass;
            Class<IStorage> storageClass = null;
            try {
                storageClass = IStorage.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            STORAGE_CLASS = storageClass;
            Class<IStorageEditorInput> storageEditorInputClass = null;
            try {
                storageEditorInputClass = IStorageEditorInput.class;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            STORAGE_EDITOR_INPUT_CLASS = storageEditorInputClass;
            JAR_ENTRY_RESOURCE_CLASS = EclipseUtil.loadClass("org.eclipse.jdt.core", "org.eclipse.jdt.core.IJarEntryResource");
            JAR_ENTRY_RESOURCE_GET_PACKAGE_FRAGMENT_ROOT = EclipseUtil.getMethod(JAR_ENTRY_RESOURCE_CLASS, "getPackageFragmentRoot", new Class[0]);
            NON_JAVA_RESOURCE_CLASS = EclipseUtil.loadClass("org.eclipse.jdt.core", "org.eclipse.jdt.internal.core.NonJavaResource");
            Field nonJavaResourceField = null;
            if (NON_JAVA_RESOURCE_CLASS != null) {
                try {
                    nonJavaResourceField = NON_JAVA_RESOURCE_CLASS.getDeclaredField("resource");
                    nonJavaResourceField.setAccessible(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            NON_JAVA_RESOURCE_FIELD = nonJavaResourceField;
        }

        private EclipseUtil() {
        }

        private static Class<?> loadClass(String bundleID, String className) {
            Bundle bundle = Platform.getBundle((String)bundleID);
            if (bundle != null && (bundle.getState() & 0x2C) != 0) {
                try {
                    return bundle.loadClass(className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }

        private static Method getMethod(Class<?> theClass, String name, Class<?> ... parameterTypes) {
            try {
                return theClass == null ? null : theClass.getMethod(name, parameterTypes);
            }
            catch (Throwable exception) {
                return null;
            }
        }

        private static Object invoke(Method method, Object object, Object ... arguments) {
            try {
                return method == null ? null : method.invoke(object, arguments);
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private static Object invoke(String methodName, Object object) {
            Method method;
            if (object != null && (method = EclipseUtil.getMethod(object.getClass(), methodName, new Class[0])) != null) {
                return EclipseUtil.invoke(method, object, new Object[0]);
            }
            return null;
        }

        public static URI getURI(IEditorInput editorInput, URIConverter uriConverter) {
            java.net.URI javaNetURI;
            IPathEditorInput pathEditorInput;
            IPath path;
            IStorage storage;
            URI uri;
            Object fileRevision;
            IFile file;
            if (FILE_CLASS != null && (file = (IFile)editorInput.getAdapter(FILE_CLASS)) != null) {
                return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            }
            if (FILE_REVISION_CLASS != null && (fileRevision = editorInput.getAdapter(FILE_REVISION_CLASS)) != null) {
                try {
                    URI uri2 = URI.createURI((String)((java.net.URI)FILE_REVISION_GET_URI_METHOD.invoke(fileRevision, new Object[0])).toString());
                    IStorage storage2 = (IStorage)EclipseUtil.invoke(FILE_REVISION_GET_STORAGE, fileRevision, new NullProgressMonitor());
                    if (storage2 != null) {
                        EclipseUtil.registerHandler(uri2, storage2, uriConverter);
                    }
                    return uri2;
                }
                catch (Throwable exception) {
                    EMFEditUIPlugin.INSTANCE.log(exception);
                }
            }
            if (STORAGE_CLASS != null && (uri = EclipseUtil.handleStorage(storage = (IStorage)editorInput.getAdapter(STORAGE_CLASS), uriConverter)) != null) {
                return uri;
            }
            if (editorInput instanceof IPathEditorInput && (path = (pathEditorInput = (IPathEditorInput)editorInput).getPath()) != null) {
                return URI.createFileURI((String)path.toString());
            }
            if (STORAGE_EDITOR_INPUT_CLASS != null && editorInput instanceof IStorageEditorInput) {
                IStorageEditorInput storageEditorInput = (IStorageEditorInput)editorInput;
                try {
                    IStorage storage3 = storageEditorInput.getStorage();
                    URI uri3 = EclipseUtil.handleStorage(storage3, uriConverter);
                    if (uri3 != null) {
                        return uri3;
                    }
                }
                catch (CoreException storage3) {
                    // empty catch block
                }
            }
            if (URI_EDITOR_INPUT_CLASS != null && editorInput instanceof IURIEditorInput) {
                return URI.createURI((String)((IURIEditorInput)editorInput).getURI().toString()).trimFragment();
            }
            URI uri4 = (URI)editorInput.getAdapter(URI.class);
            if (uri4 == null && (javaNetURI = (java.net.URI)editorInput.getAdapter(java.net.URI.class)) != null) {
                uri4 = URI.createURI((String)javaNetURI.toString());
            }
            return uri4;
        }

        private static IFile getNonJavaResourceFieldValue(Object object) {
            if (NON_JAVA_RESOURCE_CLASS != null && NON_JAVA_RESOURCE_CLASS.isInstance(object)) {
                try {
                    return (IFile)NON_JAVA_RESOURCE_FIELD.get(object);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            return null;
        }

        private static URI handleStorage(IStorage storage, URIConverter uriConverter) {
            IPath path;
            if (storage != null && (path = storage.getFullPath()) != null) {
                if (JAR_ENTRY_RESOURCE_CLASS.isInstance(storage)) {
                    IPath archivePath;
                    IFile file = EclipseUtil.getNonJavaResourceFieldValue(storage);
                    if (file != null) {
                        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    }
                    Object packageFragmentRoot = EclipseUtil.invoke(JAR_ENTRY_RESOURCE_GET_PACKAGE_FRAGMENT_ROOT, storage, new Object[0]);
                    if (packageFragmentRoot != null && (archivePath = (IPath)EclipseUtil.invoke("getPath", packageFragmentRoot)) != null) {
                        return URI.createURI((String)("archive:" + URI.createFileURI((String)archivePath.toString()) + "!" + path));
                    }
                }
                URI uri = URI.createURI((String)path.toString());
                EclipseUtil.registerHandler(uri, storage, uriConverter);
                return uri;
            }
            return null;
        }

        private static void registerHandler(URI uri, IStorage storage, URIConverter uriConverter) {
            if (uriConverter != null) {
                EList uriHandlers = uriConverter.getURIHandlers();
                for (URIHandler uriHandler : uriHandlers) {
                    if (!(uriHandler instanceof StorageURIHandler)) continue;
                    return;
                }
                URI logicalURI = URI.createURI((String)"storage:/").appendSegments(uri.segments());
                uriConverter.getURIMap().put(uri, logicalURI);
                uriHandlers.add(0, (Object)new StorageURIHandler(logicalURI, storage));
            }
        }

        public static IEditorInput createFileEditorInput(IFile file) {
            return new FileEditorInput(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StorageURIHandler
    extends URIHandlerImpl {
        private final URI uri;
        private final IStorage storage;

        private StorageURIHandler(URI uri, IStorage storage) {
            this.uri = uri;
            this.storage = storage;
        }

        public boolean canHandle(URI uri) {
            return uri.equals(this.uri);
        }

        public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
            try {
                return this.storage.getContents();
            }
            catch (CoreException exception) {
                throw new Resource.IOWrappedException((Exception)((Object)exception));
            }
        }

        public boolean exists(URI uri, Map<?, ?> options) {
            return true;
        }

        public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>();
            Set requestedAttributes = this.getRequestedAttributes(options);
            if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
                result.put("readOnly", this.storage.isReadOnly());
            }
            return result;
        }
    }
}

