/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ReorgMoveStarter {
    private final JavaMoveProcessor fMoveProcessor;

    private ReorgMoveStarter(JavaMoveProcessor moveProcessor) {
        Assert.isNotNull((Object)moveProcessor);
        this.fMoveProcessor = moveProcessor;
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IReorgDestination destination) throws JavaModelException {
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, javaElements);
        if (!policy.canEnable()) {
            return null;
        }
        JavaMoveProcessor processor = new JavaMoveProcessor(policy);
        if (processor.setDestination(destination).hasError()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public boolean run(Shell parent) throws InterruptedException, InvocationTargetException {
        MoveRefactoring ref = new MoveRefactoring((MoveProcessor)this.fMoveProcessor);
        if (this.fMoveProcessor.hasAllInputSet()) {
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries(parent));
            this.fMoveProcessor.setReorgQueries(new ReorgQueries(parent));
            new RefactoringExecutionHelper((Refactoring)ref, RefactoringCore.getConditionCheckingFailedSeverity(), this.fMoveProcessor.getSaveMode(), parent, (IRunnableContext)context).perform(false, false);
            return true;
        }
        ReorgMoveWizard wizard = new ReorgMoveWizard(this.fMoveProcessor, (Refactoring)ref);
        this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
        this.fMoveProcessor.setReorgQueries(new ReorgQueries((Wizard)wizard));
        return new RefactoringStarter().activate(wizard, parent, RefactoringMessages.OpenRefactoringWizardAction_refactoring, this.fMoveProcessor.getSaveMode());
    }
}

