/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.business.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IQueryValidationEngine;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.InvalidAcceleoPackageException;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.acceleo.query.runtime.QueryValidation;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.acceleo.aql.business.AQLSiriusPlugin;
import org.eclipse.sirius.common.acceleo.aql.business.api.ExpressionTrimmer;
import org.eclipse.sirius.common.acceleo.aql.business.api.TypesUtil;
import org.eclipse.sirius.common.acceleo.aql.business.internal.AcceleoAbstractInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class AQLSiriusInterpreter
extends AcceleoAbstractInterpreter {
    private LoadingCache<String, IQueryBuilderEngine.AstResult> parsedExpressions;
    private IQueryEnvironment queryEnvironment;
    private ECrossReferenceAdapter siriusXref;
    private CrossReferenceProvider xRef = new CrossReferenceProvider(){

        public Collection<EStructuralFeature.Setting> getInverseReferences(EObject self) {
            if (AQLSiriusInterpreter.this.siriusXref != null) {
                return AQLSiriusInterpreter.this.siriusXref.getInverseReferences(self);
            }
            return Collections.EMPTY_SET;
        }
    };
    private final ClassLoadingCallback callback = new ClassLoadingCallback(){

        public void loaded(String qualifiedName, Class<?> clazz) {
            try {
                AQLSiriusInterpreter.this.queryEnvironment.registerServicePackage(clazz);
            }
            catch (InvalidAcceleoPackageException e) {
                AQLSiriusPlugin.INSTANCE.log(new Status(2, AQLSiriusPlugin.INSTANCE.getSymbolicName(), "Error loading Java extension class " + qualifiedName + " :" + e.getMessage(), (Throwable)e));
            }
        }

        public void notFound(String qualifiedName) {
            AQLSiriusPlugin.INSTANCE.log(new Status(2, AQLSiriusPlugin.INSTANCE.getSymbolicName(), "Could not find Java extension class " + qualifiedName));
        }

        public void unloaded(String qualifiedName, Class<?> clazz) {
            AQLSiriusInterpreter.this.queryEnvironment.removeServicePackage(clazz);
        }
    };
    private final EPackageLoadingCallback ePackageCallBack;

    public AQLSiriusInterpreter() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)this.xRef);
        this.ePackageCallBack = new EPackageLoadingCallback(){

            public void loaded(String nsURI, EPackage pak) {
                AQLSiriusInterpreter.this.queryEnvironment.registerEPackage(pak);
            }

            public void unloaded(String nsURI, EPackage pak) {
                AQLSiriusInterpreter.this.queryEnvironment.removeEPackage(pak.getNsPrefix());
            }
        };
        this.javaExtensions.addClassLoadingCallBack(this.callback);
        this.javaExtensions.addEPackageCallBack(this.ePackageCallBack);
        final IQueryBuilderEngine builder = QueryParsing.newBuilder((IQueryEnvironment)this.queryEnvironment);
        this.parsedExpressions = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<String, IQueryBuilderEngine.AstResult>(){

            public IQueryBuilderEngine.AstResult load(String key) throws Exception {
                return builder.build(key);
            }
        });
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
        LinkedHashSet additionalEPackages = Sets.newLinkedHashSet();
        for (MetamodelDescriptor descriptor : metamodels) {
            EPackage pkg;
            if (!(descriptor instanceof EcoreMetamodelDescriptor) || (pkg = ((EcoreMetamodelDescriptor)descriptor).resolve()) == null) continue;
            additionalEPackages.add(pkg);
        }
        for (EPackage ePackage : additionalEPackages) {
            this.queryEnvironment.registerEPackage(ePackage);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.javaExtensions.removeClassLoadingCallBack(this.callback);
        this.javaExtensions.removeEPackageCallBack(this.ePackageCallBack);
    }

    public Object evaluate(EObject target, String fullExpression) throws EvaluationException {
        String expression = new ExpressionTrimmer(fullExpression).getExpression();
        Map<String, Object> variables = this.getVariables();
        variables.put("self", target);
        try {
            IQueryBuilderEngine.AstResult build = (IQueryBuilderEngine.AstResult)this.parsedExpressions.get((Object)expression);
            IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine((IQueryEnvironment)this.queryEnvironment);
            EvaluationResult evalResult = evaluationEngine.eval(build, variables);
            if (evalResult.getDiagnostic().getSeverity() == 4) {
                throw new EvaluationException(evalResult.getDiagnostic().getMessage(), evalResult.getDiagnostic().getException());
            }
            return evalResult.getResult();
        }
        catch (ExecutionException e) {
            throw new EvaluationException(e.getCause());
        }
    }

    public String getVariablePrefix() {
        return null;
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        this.siriusXref = crossReferencer;
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public boolean supportsValidation() {
        return true;
    }

    public ValidationResult analyzeExpression(IInterpreterContext context, String fullExpression) {
        String trimmedExpression = new ExpressionTrimmer(fullExpression).getExpression();
        ValidationResult result = new ValidationResult();
        Map<String, Set<IType>> variableTypes = TypesUtil.createAQLVariableTypesFromInterpreterContext(context, this.queryEnvironment);
        IQueryValidationEngine validator = QueryValidation.newEngine((IQueryEnvironment)this.queryEnvironment);
        try {
            IValidationResult validationResult = validator.validate(trimmedExpression, variableTypes);
            for (IValidationMessage message : validationResult.getMessages()) {
                result.addStatus(InterpreterStatusFactory.createInterpreterStatus((IInterpreterContext)context, (String)"warning", (String)message.getMessage()));
            }
            ArrayList classifierNames = Lists.newArrayList();
            for (IType type : validationResult.getPossibleTypes(validationResult.getAstResult().getAst())) {
                EClassifierType eClassifierType;
                if (type instanceof EClassifierType && (eClassifierType = (EClassifierType)type).getType() != null && eClassifierType.getType().getName() != null) {
                    String typeName = eClassifierType.getType().getName();
                    if (eClassifierType.getType().getEPackage() != null && eClassifierType.getType().getEPackage().getName() != null) {
                        typeName = String.valueOf(eClassifierType.getType().getEPackage().getName()) + "." + typeName;
                    }
                    classifierNames.add(typeName);
                }
                result.setReturnType(VariableType.fromStrings((Collection)classifierNames));
            }
        }
        catch (AcceleoQueryValidationException e) {
            result.addStatus(InterpreterStatusFactory.createInterpreterStatus((IInterpreterContext)context, (String)"error", (String)e.getMessage()));
            AQLSiriusPlugin.INSTANCE.log(new Status(4, AQLSiriusPlugin.INSTANCE.getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        catch (AcceleoQueryEvaluationException e) {
            result.addStatus(InterpreterStatusFactory.createInterpreterStatus((IInterpreterContext)context, (String)"error", (String)e.getMessage()));
        }
        return result;
    }

    public CrossReferenceProvider getCrossReferenceProvider() {
        return this.xRef;
    }

    public String getPrefix() {
        return "aql:";
    }

    public boolean provides(String expression) {
        return expression != null && expression.startsWith("aql:");
    }

    public IQueryEnvironment getQueryEnvironment() {
        return this.queryEnvironment;
    }
}

