/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class MarkerUtil {
    protected MarkerUtil() {
    }

    public static Option<IMarker> addMarkerFor(IResource resource, String message, int severity, String type) {
        try {
            if (resource != null) {
                IMarker marker = resource.createMarker(type);
                marker.setAttribute("severity", severity);
                marker.setAttribute("message", (Object)message);
                Options.newSome((Object)marker);
            }
        }
        catch (CoreException e) {
            DslCommonPlugin.getDefault().getLog().log(e.getStatus());
        }
        return Options.newNone();
    }

    public static void removeMarkerFor(IResource resource, String type) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers(type, false, 0);
            }
        }
        catch (CoreException e) {
            DslCommonPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public static void setAttribute(IMarker marker, String attributeName, Object value) {
        try {
            if (marker != null) {
                marker.setAttribute(attributeName, value);
            }
        }
        catch (CoreException e) {
            DslCommonPlugin.getDefault().getLog().log(e.getStatus());
        }
    }
}

