/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.operation;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;

public class ShiftDirectBorderedNodesOperation
extends AbstractModelChangeOperation<Void> {
    private Dimension delta;
    private final List<Node> children;

    public ShiftDirectBorderedNodesOperation(List<Node> children, Dimension delta) {
        super("Shift bordered nodes' positions by " + delta);
        this.children = children;
        this.delta = delta;
    }

    @Override
    public Void execute() {
        for (Node child : this.children) {
            LayoutConstraint layoutConstraint = child.getLayoutConstraint();
            if (!(layoutConstraint instanceof Location) || this.delta == null || this.delta.width == 0 && this.delta.height == 0) continue;
            Location location = (Location)layoutConstraint;
            location.setX(location.getX() + this.delta.width);
            location.setY(location.getY() + this.delta.height);
        }
        return null;
    }
}

