/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;

public class LayoutData
extends AbstractLayoutData {
    private EObject target;
    private Dimension size;
    private Point location;
    private List<LayoutData> children;
    private List<EdgeLayoutData> outgoingEdgeLayoutDatas = new ArrayList<EdgeLayoutData>();
    private List<EdgeLayoutData> incomingEdgeLayoutDatas = new ArrayList<EdgeLayoutData>();

    public LayoutData() {
    }

    public LayoutData(LayoutData parent, AbstractDNode target, Node gmfNode) {
        this.setParent(parent);
        this.init(target, gmfNode);
    }

    protected void init(AbstractDNode nodeTarget, Node gmfNode) {
        this.target = nodeTarget;
        LayoutConstraint constaint = gmfNode.getLayoutConstraint();
        if (constaint instanceof Size) {
            this.size = new Dimension(((Size)constaint).getWidth(), ((Size)constaint).getHeight());
        }
        if (constaint instanceof Location) {
            this.location = new Point(((Location)constaint).getX(), ((Location)constaint).getY());
        }
        this.children = new ArrayList<LayoutData>();
        if (this.target instanceof DNode) {
            this.addNodeChildren();
        } else if (this.target instanceof DNodeContainer) {
            this.addNodeContainerChildren();
        } else if (this.target instanceof DNodeList) {
            this.addNodeListChildren();
        } else {
            DiagramPlugin.getDefault().logWarning("This kind of diagram element  (" + this.target.getClass().getName() + ") is not yet managed by the LayoutDataManager.");
        }
        if (this.target instanceof EdgeTarget) {
            this.addOutgoingEdge();
            this.addIncomingEdge();
        }
    }

    protected void addNodeChildren() {
        for (DNode child : ((DNode)this.target).getOwnedBorderedNodes()) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            this.children.add(new LayoutData(this, (AbstractDNode)child, gmfNode));
        }
    }

    protected void addNodeContainerChildren() {
        Node gmfNode;
        for (DDiagramElement child : ((DNodeContainer)this.target).getOwnedDiagramElements()) {
            if (!(child instanceof AbstractDNode) || (gmfNode = SiriusGMFHelper.getGmfNode(child)) == null) continue;
            this.children.add(new LayoutData(this, (AbstractDNode)child, gmfNode));
        }
        for (DDiagramElement child : ((DNodeContainer)this.target).getOwnedBorderedNodes()) {
            gmfNode = SiriusGMFHelper.getGmfNode(child);
            if (gmfNode == null) continue;
            this.children.add(new LayoutData(this, (AbstractDNode)child, gmfNode));
        }
    }

    protected void addNodeListChildren() {
        Node gmfNode;
        for (DNodeListElement child : ((DNodeList)this.target).getOwnedElements()) {
            gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            this.children.add(new LayoutData(this, (AbstractDNode)child, gmfNode));
        }
        for (DNodeListElement child : ((DNodeList)this.target).getOwnedBorderedNodes()) {
            gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            this.children.add(new LayoutData(this, (AbstractDNode)child, gmfNode));
        }
    }

    protected void addOutgoingEdge() {
        for (DEdge outgoingEdge : ((EdgeTarget)this.target).getOutgoingEdges()) {
            Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)outgoingEdge);
            if (gmfEdge == null) continue;
            this.outgoingEdgeLayoutDatas.add(new EdgeLayoutData(this, outgoingEdge, gmfEdge));
        }
    }

    protected void addIncomingEdge() {
        for (DEdge incomingEdge : ((EdgeTarget)this.target).getIncomingEdges()) {
            Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)incomingEdge);
            if (gmfEdge == null) continue;
            this.incomingEdgeLayoutDatas.add(new EdgeLayoutData(this, incomingEdge, gmfEdge));
        }
    }

    public EObject getTarget() {
        return this.target;
    }

    public List<LayoutData> getChildren() {
        return this.children;
    }

    public LayoutData getData(AbstractDNode node, boolean ignoreConsumeState) {
        LayoutData result = null;
        if ((ignoreConsumeState || !this.isConsume()) && this.getTarget().equals(node)) {
            result = this;
        } else {
            for (LayoutData layoutData : this.getChildren()) {
                result = layoutData.getData(node, ignoreConsumeState);
                if (result != null) break;
            }
        }
        return result;
    }

    public EdgeLayoutData getData(DEdge edge, boolean ignoreConsumeState) {
        EdgeLayoutData result = null;
        for (EdgeLayoutData edgeLayoutData : this.outgoingEdgeLayoutDatas) {
            if (!ignoreConsumeState && edgeLayoutData.isConsume() || !edgeLayoutData.getTarget().equals(edge)) continue;
            result = edgeLayoutData;
            break;
        }
        if (result == null) {
            for (EdgeLayoutData edgeLayoutData : this.incomingEdgeLayoutDatas) {
                if (!ignoreConsumeState && edgeLayoutData.isConsume() || !edgeLayoutData.getTarget().equals(edge)) continue;
                result = edgeLayoutData;
                break;
            }
        }
        if (result == null) {
            for (LayoutData layoutData : this.getChildren()) {
                result = layoutData.getData(edge, ignoreConsumeState);
                if (result != null) break;
            }
        }
        return result;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Point getLocation() {
        return this.location;
    }

    public boolean isAllConsume() {
        boolean isAllConsume = this.isConsume();
        for (LayoutData layoutData : this.getChildren()) {
            boolean bl = isAllConsume = isAllConsume && layoutData.isAllConsume();
            if (!isAllConsume) break;
        }
        for (EdgeLayoutData edgeLayoutData : this.outgoingEdgeLayoutDatas) {
            boolean bl = isAllConsume = isAllConsume && edgeLayoutData.isConsume();
            if (!isAllConsume) break;
        }
        if (isAllConsume) {
            for (EdgeLayoutData edgeLayoutData : this.incomingEdgeLayoutDatas) {
                boolean bl = isAllConsume = isAllConsume && edgeLayoutData.isConsume();
                if (!isAllConsume) break;
            }
        }
        return isAllConsume;
    }

    protected void setTarget(EObject target) {
        if (!(target instanceof AbstractDNode || target instanceof DDiagram || target instanceof DEdge)) {
            throw new IllegalArgumentException("The target of a LayoutData can only be an AbstractDNode, a DEdge or a DDiagram.");
        }
        this.target = target;
    }

    protected void setTarget(DDiagram target) {
        this.target = target;
    }

    protected void setSize(Dimension size) {
        this.size = size;
    }

    protected void setLocation(Point location) {
        this.location = location;
    }

    protected void setChildren(List<LayoutData> children) {
        this.children = children;
    }

    public String toString() {
        String toString = this.getTarget().toString();
        if (this.getLocation() != null) {
            toString = String.valueOf(toString) + ", " + this.getLocation().toString();
        }
        if (this.getSize() != null) {
            toString = String.valueOf(toString) + ", " + this.getSize().toString();
        }
        return toString;
    }
}

