/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;

public class CenterEditPartEdgesCommand
extends AbstractTransactionalCommand {
    private IGraphicalEditPart editPart;
    private ChangeBoundsRequest request;

    public CenterEditPartEdgesCommand(IGraphicalEditPart graphicalEditPart, ChangeBoundsRequest request) {
        super(graphicalEditPart.getEditingDomain(), "Center Edges", null);
        this.editPart = graphicalEditPart;
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ArrayList edges = new ArrayList();
        edges.addAll(this.editPart.getSourceConnections());
        edges.addAll(this.editPart.getTargetConnections());
        for (ConnectionEditPart connection : Iterables.filter(edges, ConnectionEditPart.class)) {
            Object model = connection.getModel();
            if (!(model instanceof Edge)) continue;
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation((Edge)model, false);
            if (this.request != null) {
                Dimension newSourceSize = this.getNewSize(connection.getSource());
                Dimension newTargetSize = this.getNewSize(connection.getTarget());
                centerEdgeEndModelChangeOperation.setSourceAndTargetSize(newSourceSize, newTargetSize);
            }
            centerEdgeEndModelChangeOperation.execute();
        }
        return CommandResult.newOKCommandResult();
    }

    private Dimension getNewSize(EditPart edgeEnd) {
        if (edgeEnd instanceof GraphicalEditPart) {
            IFigure figure = ((GraphicalEditPart)edgeEnd).getFigure();
            Rectangle newBounds = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)newBounds);
            List editPartRequesting = this.request.getEditParts();
            if (editPartRequesting.contains(edgeEnd)) {
                newBounds = this.request.getTransformedRectangle(newBounds);
            }
            figure.translateToRelative((Translatable)newBounds);
            return newBounds.getSize();
        }
        return null;
    }

    public void dispose() {
        this.editPart = null;
        this.request = null;
        super.dispose();
    }
}

