/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.pinning;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.tools.internal.commands.PinElementsCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.pinning.AbstractPinUnpinElementsEclipseAction;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;

public class PinElementsEclipseAction
extends AbstractPinUnpinElementsEclipseAction {
    private static final String PIN_SELECTED_ELEMENTS = "Pin selected elements";

    public PinElementsEclipseAction() {
        super(PIN_SELECTED_ELEMENTS, "pinElementsAction", PIN_SELECTED_ELEMENTS, "icons/pin.gif");
    }

    @Override
    protected Command createCommand(Collection<DDiagramElement> elements) {
        return new PinElementsCommand(elements);
    }

    @Override
    protected boolean doIsEnabled(Collection<DDiagramElement> selectedDiagramElements) {
        boolean result = true;
        PinHelper pinHelper = new PinHelper();
        for (DDiagramElement dDiagramElement : selectedDiagramElements) {
            result = result && pinHelper.isPinned(dDiagramElement);
            Resource dDiagramElementResource = dDiagramElement.eResource();
            if (dDiagramElementResource != null && PermissionAuthorityRegistry.getDefault().getPermissionAuthority(dDiagramElementResource.getResourceSet()).canEditInstance((EObject)dDiagramElement.getParentDiagram())) continue;
            result = true;
            break;
        }
        return !result;
    }
}

