/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class ResetStylePropertiesToDefaultValuesCommand
extends RecordingCommand {
    private DDiagram dDiagram;
    private Map<View, DDiagramElement> customizedViews;

    public ResetStylePropertiesToDefaultValuesCommand(TransactionalEditingDomain domain, DDiagram dDiagram, Map<View, DDiagramElement> customizedViews) {
        super(domain, "Reset style properties to default values");
        this.dDiagram = dDiagram;
        this.customizedViews = customizedViews;
    }

    protected void doExecute() {
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)this.dDiagram);
        MappingHelper mappingHelper = new MappingHelper(interpreter);
        StyleHelper styleHelper = new StyleHelper(interpreter);
        for (Map.Entry<View, DDiagramElement> entry : this.customizedViews.entrySet()) {
            View view = entry.getKey();
            DDiagramElement dDiagramElement = entry.getValue();
            if (dDiagramElement != null) {
                this.resetDDiagramElementCustomizations(dDiagramElement, mappingHelper, styleHelper);
            }
            this.resetViewStylePropertiesToDefaultValues(view);
        }
    }

    private void resetDDiagramElementCustomizations(DDiagramElement dDiagramElement, MappingHelper mappingHelper, StyleHelper styleHelper) {
        DNodeListElement dNodeElementElement;
        DSemanticDecorator parentDDiagramElt = (DSemanticDecorator)dDiagramElement.eContainer();
        DiagramElementMapping diagramElementMapping = dDiagramElement.getDiagramElementMapping();
        if (dDiagramElement instanceof DEdge) {
            DEdge dEdge = (DEdge)dDiagramElement;
            if (dEdge.getOwnedStyle() != null) {
                org.eclipse.sirius.viewpoint.Style bestStyle;
                dEdge.getOwnedStyle().getCustomFeatures().clear();
                if (dEdge.getOwnedStyle().getBeginLabelStyle() != null) {
                    dEdge.getOwnedStyle().getBeginLabelStyle().getCustomFeatures().clear();
                }
                if (dEdge.getOwnedStyle().getCenterLabelStyle() != null) {
                    dEdge.getOwnedStyle().getCenterLabelStyle().getCustomFeatures().clear();
                }
                if (dEdge.getOwnedStyle().getEndLabelStyle() != null) {
                    dEdge.getOwnedStyle().getEndLabelStyle().getCustomFeatures().clear();
                }
                if ((bestStyle = mappingHelper.getBestStyle(diagramElementMapping, dEdge.getTarget(), (EObject)dEdge, parentDDiagramElt.getTarget(), this.dDiagram)) instanceof EdgeStyle) {
                    EdgeStyle edgeStyle = (EdgeStyle)bestStyle;
                    dEdge.setOwnedStyle(edgeStyle);
                    styleHelper.refreshStyle((org.eclipse.sirius.viewpoint.Style)edgeStyle);
                }
            }
        } else if (dDiagramElement instanceof DNode) {
            DNode dNode = (DNode)dDiagramElement;
            if (dNode.getOwnedStyle() != null) {
                dNode.getOwnedStyle().getCustomFeatures().clear();
                org.eclipse.sirius.viewpoint.Style bestStyle = mappingHelper.getBestStyle(diagramElementMapping, dNode.getTarget(), (EObject)dNode, parentDDiagramElt.getTarget(), this.dDiagram);
                if (bestStyle instanceof NodeStyle) {
                    NodeStyle nodeStyle = (NodeStyle)bestStyle;
                    dNode.setOwnedStyle(nodeStyle);
                    styleHelper.refreshStyle((org.eclipse.sirius.viewpoint.Style)nodeStyle);
                }
            }
        } else if (dDiagramElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer dDiagramElementContainer = (DDiagramElementContainer)dDiagramElement;
            if (dDiagramElementContainer.getOwnedStyle() != null) {
                dDiagramElementContainer.getOwnedStyle().getCustomFeatures().clear();
                org.eclipse.sirius.viewpoint.Style bestStyle = mappingHelper.getBestStyle(diagramElementMapping, dDiagramElementContainer.getTarget(), (EObject)dDiagramElementContainer, parentDDiagramElt.getTarget(), this.dDiagram);
                if (bestStyle instanceof ContainerStyle) {
                    ContainerStyle containerStyle = (ContainerStyle)bestStyle;
                    dDiagramElementContainer.setOwnedStyle(containerStyle);
                    styleHelper.refreshStyle((org.eclipse.sirius.viewpoint.Style)containerStyle);
                }
            }
        } else if (dDiagramElement instanceof DNodeListElement && (dNodeElementElement = (DNodeListElement)dDiagramElement).getOwnedStyle() != null) {
            dNodeElementElement.getOwnedStyle().getCustomFeatures().clear();
            org.eclipse.sirius.viewpoint.Style bestStyle = mappingHelper.getBestStyle(diagramElementMapping, dNodeElementElement.getTarget(), (EObject)dNodeElementElement, parentDDiagramElt.getTarget(), this.dDiagram);
            if (bestStyle instanceof NodeStyle) {
                NodeStyle nodeStyle = (NodeStyle)bestStyle;
                dNodeElementElement.setOwnedStyle(nodeStyle);
                styleHelper.refreshStyle((org.eclipse.sirius.viewpoint.Style)nodeStyle);
            }
        }
    }

    private void resetViewStylePropertiesToDefaultValues(View view) {
        ViewQuery viewQuery = new ViewQuery(view);
        for (Object obj : view.getStyles()) {
            if (!(obj instanceof Style)) continue;
            Style style = (Style)obj;
            for (EAttribute eAttribute : style.eClass().getEAllAttributes()) {
                if (!ViewQuery.CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES.contains(eAttribute)) continue;
                Object currentValue = style.eGet((EStructuralFeature)eAttribute);
                Object defaultValue = viewQuery.getDefaultValue(eAttribute);
                if ((currentValue == null || currentValue.equals(defaultValue)) && (currentValue != null || defaultValue == null)) continue;
                style.eSet((EStructuralFeature)eAttribute, defaultValue);
            }
        }
        if (view instanceof Shape || view instanceof Connector) {
            for (EAttribute eAttribute : view.eClass().getEAllAttributes()) {
                if (!NotationPackage.Literals.STYLE.isSuperTypeOf(eAttribute.getEContainingClass()) || !ViewQuery.CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES.contains(eAttribute)) continue;
                Object currentValue = view.eGet((EStructuralFeature)eAttribute);
                Object defaultValue = viewQuery.getDefaultValue(eAttribute);
                if ((currentValue == null || currentValue.equals(defaultValue)) && (currentValue != null || defaultValue == null)) continue;
                view.eSet((EStructuralFeature)eAttribute, defaultValue);
            }
        }
        new ViewPropertiesSynchronizer().synchronizeViewProperties(view);
    }
}

