/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.SiriusTransPlugin;
import org.eclipse.sirius.common.ui.tools.api.editor.IEObjectNavigable;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.business.internal.navigation.MappingDefinitionFinder;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class SpecificationMenuContribution
implements IContributionItemProvider {
    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        IGraphicalEditPart curPart;
        EObject designerObj;
        EditPart editpart;
        SiriusDiagramEditor diagrampart;
        EObject element;
        if (part instanceof SiriusDiagramEditor && (element = (diagrampart = (SiriusDiagramEditor)part).getDiagramEditPart().resolveSemanticElement()) instanceof DSemanticDiagram && (editpart = diagrampart.getDiagramGraphicalViewer().getFocusEditPart()) instanceof IGraphicalEditPart && !(editpart instanceof NoteEditPart) && (designerObj = (curPart = (IGraphicalEditPart)editpart).resolveSemanticElement()) != null) {
            this.buildOpenExistingSpecification(menu, designerObj);
        }
    }

    private void buildOpenExistingSpecification(IMenuManager menu, EObject designerObj) {
        Resource resource;
        final EObject description = this.getDescription(designerObj);
        if (description != null && (resource = description.eResource()) != null) {
            final IFile modelFile = WorkspaceSynchronizer.getFile((Resource)resource);
            ImageDescriptor imageDescriptor = SiriusTransPlugin.getBundledImageDescriptor((String)"/icons/LinkToSirius.gif");
            IItemLabelProvider labelProvider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)description, IItemLabelProvider.class);
            if (labelProvider != null) {
                imageDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)description));
            }
            if (modelFile != null) {
                Action openAction = new Action("Open Definition", imageDescriptor){

                    public void run() {
                        super.run();
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                        IWorkbenchPage page = workbenchWindow.getActivePage();
                        try {
                            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(modelFile), workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
                            if (editor instanceof IEObjectNavigable) {
                                ((IEObjectNavigable)editor).navigateToEObject(EcoreUtil.getURI((EObject)description));
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                };
                openAction.setId("Open Definition");
                menu.insertAfter("additions", (IAction)openAction);
            }
        }
    }

    private EObject getDescription(EObject designerObj) {
        return new MappingDefinitionFinder().getDefinition(designerObj);
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }

    private AdapterFactory getAdapterFactory() {
        return DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();
    }
}

