/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.repair.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.migration.resource.session.commands.MigrationCommandExecutor;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.internal.repair.commands.RefreshAllElementsVisibilityCommand;
import org.eclipse.sirius.diagram.business.internal.repair.resource.DiagramKey;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostEdgeData;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataState;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostElementDataWithMapping;
import org.eclipse.sirius.diagram.business.internal.repair.resource.session.diagram.data.LostNodeData;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationContainer;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class RepairRepresentationRefresher {
    private ListMultimap<DiagramKey, LostNodeData> lostNodesByDelete;
    private ListMultimap<DiagramKey, LostEdgeData> lostEdgesByDelete;

    public RepairRepresentationRefresher(ListMultimap lostNodesByDelete, ListMultimap lostEdgesByDelete) {
        this.lostNodesByDelete = lostNodesByDelete;
        this.lostEdgesByDelete = lostEdgesByDelete;
    }

    public void refreshRepresentations(DAnalysis dAnalysis, final DView view) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)dAnalysis);
        boolean hasAlreadyModel = false;
        if (view instanceof DRepresentationContainer) {
            Map extension;
            AnyType viewSettings;
            if (!((DAnalysis)view.eContainer()).getModels().isEmpty()) {
                for (EObject model : ((DAnalysis)view.eContainer()).getModels()) {
                    if (model.eIsProxy()) continue;
                    hasAlreadyModel = true;
                }
            } else if (!hasAlreadyModel && (viewSettings = (AnyType)(extension = ((XMIResource)dAnalysis.eResource()).getEObjectToExtensionMap()).get(view)) != null) {
                for (FeatureMap.Entry feature : viewSettings.getMixed()) {
                    if (!"model".equals(feature.getEStructuralFeature().getName())) continue;
                    ((DAnalysis)view.eContainer()).getModels().add((Object)EcoreUtil.resolve((EObject)((EObject)feature.getValue()), (ResourceSet)view.eResource().getResourceSet()));
                    hasAlreadyModel = true;
                }
            }
        }
        MigrationCommandExecutor migrationCommandExecutor = new MigrationCommandExecutor();
        IdentityCommand prepareImportsFromSessionCommand = new IdentityCommand(){

            public void execute() {
                for (EObject model : ((DAnalysis)view.eContainer()).getModels()) {
                    if (model.eIsProxy()) continue;
                    InterpreterRegistry.prepareImportsFromSession((IInterpreter)SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(model), (Session)SessionManager.INSTANCE.getSession(model));
                }
                for (DRepresentation dRepresentation : view.getOwnedRepresentations()) {
                    DialectManager.INSTANCE.refresh(dRepresentation, (IProgressMonitor)new NullProgressMonitor());
                }
            }

            public boolean canUndo() {
                return false;
            }
        };
        migrationCommandExecutor.execute(transactionalEditingDomain, (Command)prepareImportsFromSessionCommand);
        this.refreshLostDiagramElements(view);
        this.refreshAllElementsVisibility(view, transactionalEditingDomain, migrationCommandExecutor);
    }

    public void refreshAllElementsVisibility(DView view, TransactionalEditingDomain transactionalEditingDomain, MigrationCommandExecutor migrationCommandExecutor) {
        for (DRepresentation representation : view.getOwnedRepresentations()) {
            if (!(representation instanceof DDiagram)) continue;
            RefreshAllElementsVisibilityCommand refreshAllElementsVisibilityCommand = new RefreshAllElementsVisibilityCommand((DDiagram)representation);
            migrationCommandExecutor.execute(transactionalEditingDomain, (Command)refreshAllElementsVisibilityCommand);
        }
    }

    private void refreshLostDiagramElements(final DView view) {
        DslCommonPlugin.PROFILER.startWork("Refresh elements lost by repair/migrate first pass");
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)view);
        IdentityCommand refreshLostDiagramElementsCommand = new IdentityCommand(){

            public void execute() {
                for (DSemanticDiagram diagram : Iterables.filter((Iterable)view.getOwnedRepresentations(), DSemanticDiagram.class)) {
                    DiagramKey diagramKey = DiagramKey.createDiagramKey(diagram);
                    List lostNodes = RepairRepresentationRefresher.this.lostNodesByDelete.get((Object)diagramKey);
                    List lostEdges = RepairRepresentationRefresher.this.lostEdgesByDelete.get((Object)diagramKey);
                    Iterable allLostElements = Iterables.concat((Iterable)lostNodes, (Iterable)lostEdges);
                    RepairRepresentationRefresher.this.refreshLostElementsThenDiagram(diagram, allLostElements);
                }
            }

            public boolean canUndo() {
                return false;
            }
        };
        new MigrationCommandExecutor().execute(transactionalEditingDomain, (Command)refreshLostDiagramElementsCommand);
        DslCommonPlugin.PROFILER.stopWork("Refresh elements lost by repair/migrate first pass");
    }

    private void refreshLostElementsThenDiagram(DSemanticDiagram designerDiagram, Iterable<? extends LostElementDataWithMapping> lostElements) {
        boolean doContinue;
        boolean needRefresh = this.refreshLostElements(designerDiagram, lostElements);
        if (needRefresh && (doContinue = this.refreshDiagramAndCheckIfNumberOfElementsHasChanged(designerDiagram))) {
            this.refreshLostElementsThenDiagram(designerDiagram, lostElements);
        }
    }

    private boolean refreshLostElements(DSemanticDiagram designerDiagram, Iterable<? extends LostElementDataWithMapping> lostElements) {
        boolean needRefresh = false;
        Iterator<? extends LostElementDataWithMapping> iterator = lostElements.iterator();
        while (iterator.hasNext()) {
            LostElementDataWithMapping data = iterator.next();
            LostElementDataState created = data.reCreateLostElement(designerDiagram);
            switch (created) {
                case NOT_CREATED: {
                    break;
                }
                case EXISTING: {
                    iterator.remove();
                    break;
                }
                default: {
                    iterator.remove();
                    needRefresh = true;
                }
            }
        }
        return needRefresh;
    }

    private boolean refreshDiagramAndCheckIfNumberOfElementsHasChanged(DSemanticDiagram designerDiagram) {
        int sizeBeforeRefresh = designerDiagram.getDiagramElements().size();
        designerDiagram.refresh();
        int sizeAfterRefresh = designerDiagram.getDiagramElements().size();
        boolean doContinue = sizeAfterRefresh > sizeBeforeRefresh;
        return doContinue;
    }
}

