/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.api.accessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtenderService;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class ModelAccessorsRegistry {
    private String discriminant;
    private Map<String, ModelAccessor> root2ExPackage = new HashMap<String, ModelAccessor>();
    private ModelAccessor nullResourceModelAccessor;

    public ModelAccessorsRegistry(String discriminantFileExtension) {
        this.discriminant = discriminantFileExtension;
    }

    public void setNullResourceModelAccessor(ModelAccessor nullResourceModelAccessor) {
        this.nullResourceModelAccessor = nullResourceModelAccessor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ModelAccessor getModelAccessor(EObject modelElement) {
        ModelAccessor result = null;
        Resource modelElementResource = null;
        if (modelElement != null) {
            modelElementResource = modelElement.eResource();
        }
        if (modelElement != null && modelElementResource != null) {
            if (modelElementResource.getResourceSet() != null) return this.getModelAccessor(modelElementResource.getResourceSet());
        }
        if (this.nullResourceModelAccessor != null) {
            return this.nullResourceModelAccessor;
        }
        if (this.root2ExPackage.size() <= 0) throw new RuntimeException("No resource to get the ExtendedPackage");
        return this.root2ExPackage.values().iterator().next();
    }

    public ModelAccessor getModelAccessor(ResourceSet resourceSet) {
        String uri = this.getMapKeyFromResource(resourceSet);
        if (!this.root2ExPackage.containsKey(uri)) {
            ModelAccessor newPack = ExtenderService.createModelAccessor(resourceSet);
            newPack.init(resourceSet);
            this.root2ExPackage.put(uri, newPack);
        }
        return this.root2ExPackage.get(uri);
    }

    public void disposeModelAccessor(EObject modelElement, String airDescriptionExtension) {
        String root;
        Resource modelElementResource = modelElement.eResource();
        if (modelElementResource != null && modelElementResource.getResourceSet() != null && this.root2ExPackage.containsKey(root = this.getMapKeyFromResource(modelElementResource.getResourceSet()))) {
            this.root2ExPackage.remove(root);
        }
    }

    public void dispose() {
        for (ModelAccessor access : this.root2ExPackage.values()) {
            access.dispose();
        }
        this.root2ExPackage.clear();
        if (this.nullResourceModelAccessor != null) {
            this.nullResourceModelAccessor.dispose();
            this.nullResourceModelAccessor = null;
        }
    }

    private Resource getDiscriminantResource(ResourceSet resourceSet) {
        for (Resource res : new ArrayList(resourceSet.getResources())) {
            if (res.getURI() == null || res.getURI().fileExtension() == null || !res.getURI().fileExtension().equals(this.discriminant)) continue;
            return res;
        }
        return null;
    }

    private String getMapKeyFromResource(ResourceSet resourceSet) {
        String uri = "";
        Resource airResource = this.getDiscriminantResource(resourceSet);
        if (airResource != null && airResource.getURI() != null) {
            uri = airResource.getURI().toString();
        }
        return uri;
    }
}

