/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.internal.permission;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthorityRegistry;
import org.eclipse.sirius.ecore.extender.business.internal.permission.PermissionService;

public class PermissionAuthorityRegistryImpl
implements IPermissionAuthorityRegistry {
    private Map<ResourceSet, IPermissionAuthority> resourceSetToAuthority = new WeakHashMap<ResourceSet, IPermissionAuthority>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IPermissionAuthority getPermissionAuthority(EObject modelElement) {
        IPermissionAuthority authority = null;
        if (modelElement instanceof Resource && ((Resource)modelElement).getResourceSet() != null) {
            return this.getPermissionAuthority(((Resource)modelElement).getResourceSet());
        }
        Resource modelElementResource = null;
        if (modelElement != null) {
            modelElementResource = modelElement.eResource();
        }
        if (modelElement != null && modelElementResource != null) {
            if (modelElementResource.getResourceSet() != null) return this.getPermissionAuthority(modelElementResource.getResourceSet());
        }
        if (this.resourceSetToAuthority.size() <= 0) throw new RuntimeException("No resource to get the ExtendedPackage");
        return this.resourceSetToAuthority.values().iterator().next();
    }

    @Override
    public IPermissionAuthority getPermissionAuthority(ResourceSet resourceSet) {
        if (!this.resourceSetToAuthority.containsKey(resourceSet)) {
            IPermissionAuthority newAuth = PermissionService.createPermissionAuthority(resourceSet);
            newAuth.init(resourceSet);
            this.resourceSetToAuthority.put(resourceSet, newAuth);
        }
        return this.resourceSetToAuthority.get(resourceSet);
    }

    @Override
    public IPermissionAuthority getPermissionAuthority(Resource res) {
        IPermissionAuthority result = null;
        if (res.getResourceSet() != null) {
            result = this.getPermissionAuthority(res.getResourceSet());
        }
        if (result == null && res.getContents().size() > 0) {
            result = this.getPermissionAuthority((EObject)res.getContents().get(0));
        }
        return result;
    }

    @Override
    public void dispose() {
        this.resourceSetToAuthority.clear();
    }
}

