/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractTransactionalTableAction;

public class HideLinesAction
extends AbstractTransactionalTableAction {
    private static final String HIDE_LINE = "Hide line";
    private static final String HIDE_LINES = "Hide lines";
    private Collection<DLine> lines = Lists.newArrayList();

    public HideLinesAction(DTable dTable, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(dTable, HIDE_LINE, DTableViewerManager.getImageRegistry().getDescriptor("table/hide"), editingDomain, tableCommandFactory);
    }

    public void setLines(Collection<DLine> linesToHide) {
        this.lines.clear();
        if (linesToHide != null && !linesToHide.isEmpty()) {
            this.lines.addAll(linesToHide);
        }
        this.setEnabled(!this.lines.isEmpty());
        this.setText(this.lines.size() <= 1 ? HIDE_LINE : HIDE_LINES);
    }

    public void run() {
        super.run();
        String commandLabel = "Set " + TablePackage.eINSTANCE.getDLine_Visible().getName() + " value";
        String name = TablePackage.eINSTANCE.getDLine_Visible().getName();
        CompoundCommand compoundCommand = new CompoundCommand(commandLabel);
        for (EObject eObject : this.lines) {
            compoundCommand.append(this.getTableCommandFactory().buildSetValue(eObject, name, (Object)false));
        }
        this.getEditingDomain().getCommandStack().execute((Command)compoundCommand);
    }

    public boolean isEnabled() {
        return super.isEnabled() && !this.lines.isEmpty();
    }
}

