/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.ui.tools.internal.commands.SortDColumnsCommand;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;

public class SortColumnsByLineAction
extends Action {
    private static final String DEFAULT_NAME = "Sort by";
    private static DLine sortedBy;
    private static int sortDirection;
    private final TransactionalEditingDomain domain;
    private DLine line;

    static {
        sortDirection = 0;
    }

    public SortColumnsByLineAction(TransactionalEditingDomain domain) {
        super(DEFAULT_NAME, DTableViewerManager.getImageRegistry().getDescriptor("table/sortByLine"));
        this.domain = domain;
    }

    public void run() {
        super.run();
        if (sortedBy != null && sortedBy.equals(this.line)) {
            sortDirection = sortDirection == 128 ? 1024 : 128;
        } else {
            sortDirection = 128;
            sortedBy = this.line;
        }
        DTable table = TableHelper.getTable((EObject)this.line);
        SortDColumnsCommand sortDColumnsCmd = new SortDColumnsCommand(this.domain, table, sortedBy, sortDirection);
        this.domain.getCommandStack().execute((Command)sortDColumnsCmd);
    }

    public boolean isEnabled() {
        return TableHelper.getTable((EObject)this.line).getDescription() instanceof CrossTableDescription;
    }

    public void setLine(DLine line) {
        this.line = line;
    }
}

