/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.business.internal.dialect;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeMapping;
import org.eclipse.sirius.tree.description.TreeNavigationDescription;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.swt.graphics.Image;

public class HierarchyLabelTreeProvider
extends LabelProvider {
    private static final String DELIMITER = " > ";
    private ILabelProvider wrappedProvider;

    public HierarchyLabelTreeProvider(ILabelProvider wrappedLabelProvider) {
        this.wrappedProvider = wrappedLabelProvider;
    }

    public Image getImage(Object element) {
        return this.wrappedProvider != null ? this.wrappedProvider.getImage(element) : super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof TreeMapping || element instanceof TreeDescription || element instanceof TreeNavigationDescription) {
            IdentifiedElement mapping = (IdentifiedElement)element;
            String text = mapping.getName();
            EObject container = mapping.eContainer();
            while (container != null && !(container instanceof Group)) {
                text = String.valueOf(this.getLabel(container)) + DELIMITER + text;
                container = container.eContainer();
            }
            return text;
        }
        return this.wrappedProvider != null ? this.wrappedProvider.getText(element) : super.getText(element);
    }

    private String getLabel(EObject eObject) {
        String label = null;
        if (eObject instanceof IdentifiedElement) {
            label = new IdentifiedElementQuery((IdentifiedElement)eObject).getLabel();
        } else if (eObject instanceof RepresentationExtensionDescription) {
            label = ((RepresentationExtensionDescription)eObject).getName();
        }
        return label != null ? label : "Element whithout name";
    }
}

