/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.AutomaticCreator;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.SemanticPartition;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeItemCreator;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeMappingProvider;
import org.eclipse.sirius.tree.description.TreeItemMapping;

class RTreeItemMapping
implements Mapping {
    private TreeItemMapping nm;
    private TreeMappingProvider provider;
    private AutomaticCreator creator;

    public RTreeItemMapping(TreeItemMapping mapping, TreeMappingProvider provider) {
        this.nm = mapping;
        this.provider = provider;
        this.creator = new TreeItemCreator(this.nm, provider);
    }

    public Option<? extends Mapping> getSuper() {
        if (this.nm.getSpecialize() != null) {
            return Options.newSome((Object)this.provider.getOrCreate(this.nm.getSpecialize()));
        }
        return Options.newNone();
    }

    public SemanticPartition getSemanticPartition() {
        return this.provider.getSemanticProvider().getSemanticPartition(this.nm);
    }

    public List<Mapping> getChildMappings() {
        ArrayList result = Lists.newArrayList();
        result.addAll(Collections2.transform(this.nm.getAllSubMappings(), (Function)new Function<TreeItemMapping, RTreeItemMapping>(){

            public RTreeItemMapping apply(TreeItemMapping from) {
                return RTreeItemMapping.this.provider.getOrCreate(from);
            }
        }));
        return result;
    }

    public boolean isEnabled() {
        return true;
    }

    public TreeItemMapping getDescription() {
        return this.nm;
    }

    public Option<AutomaticCreator> getCreator() {
        return Options.newSome((Object)this.creator);
    }
}

