/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.export;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.tools.internal.actions.export.AbstractExportRepresentationsAction;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportRepresentationsAction
extends AbstractExportRepresentationsAction {
    private static Predicate<DRepresentation> exportableRepresentation = new Predicate<DRepresentation>(){

        public boolean apply(DRepresentation input) {
            return DialectUIManager.INSTANCE.canExport(input, new ExportFormat(ExportFormat.ExportDocumentFormat.NONE, null));
        }
    };
    private final Session session;
    private Collection<EObject> selectedEObjects;
    private Collection<DRepresentation> selectedRepresentations;

    public ExportRepresentationsAction(Session session, Collection<EObject> selectedEObjects, Collection<DRepresentation> selectedRepresentations) {
        super(SiriusEditPlugin.INSTANCE.getString("exportRepresentationsAsImagesActionLabel"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/image.gif"));
        this.session = session;
        this.selectedEObjects = selectedEObjects;
        this.selectedRepresentations = selectedRepresentations;
    }

    @Override
    public void run() {
        if (!this.getDRepresentationToExport().isEmpty()) {
            super.run();
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Export representations", (String)"The selected elements do not contain any representation to export.");
        }
    }

    @Override
    protected Collection<DRepresentation> getDRepresentationToExport() {
        LinkedHashSet dRepresentationsToExport = Sets.newLinkedHashSet(this.selectedRepresentations);
        if (dRepresentationsToExport.isEmpty()) {
            dRepresentationsToExport.addAll(this.computeAllRepresentationsUnderSemantic());
        }
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)dRepresentationsToExport, exportableRepresentation));
    }

    @Override
    protected Session getSession(DRepresentation representation) {
        return this.session;
    }

    private Collection<DRepresentation> computeAllRepresentationsUnderSemantic() {
        LinkedHashSet<DRepresentation> result = new LinkedHashSet<DRepresentation>();
        for (EObject eObject : this.selectedEObjects) {
            result.addAll(DialectManager.INSTANCE.getRepresentations(eObject, this.session));
            TreeIterator iter = eObject.eAllContents();
            while (iter.hasNext()) {
                EObject child = (EObject)iter.next();
                result.addAll(DialectManager.INSTANCE.getRepresentations(child, this.session));
            }
        }
        return result;
    }
}

